/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ChannelTargetInfo;
import software.amazon.awssdk.services.ssmcontacts.model.ContactTargetInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<ChannelTargetInfo> CHANNEL_TARGET_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChannelTargetInfo").getter(Target.getter(Target::channelTargetInfo)).setter(Target.setter(Builder::channelTargetInfo)).constructor(ChannelTargetInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelTargetInfo").build()}).build();
    private static final SdkField<ContactTargetInfo> CONTACT_TARGET_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactTargetInfo").getter(Target.getter(Target::contactTargetInfo)).setter(Target.setter(Builder::contactTargetInfo)).constructor(ContactTargetInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactTargetInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TARGET_INFO_FIELD, CONTACT_TARGET_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final ChannelTargetInfo channelTargetInfo;
    private final ContactTargetInfo contactTargetInfo;

    private Target(BuilderImpl builder) {
        this.channelTargetInfo = builder.channelTargetInfo;
        this.contactTargetInfo = builder.contactTargetInfo;
    }

    public final ChannelTargetInfo channelTargetInfo() {
        return this.channelTargetInfo;
    }

    public final ContactTargetInfo contactTargetInfo() {
        return this.contactTargetInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTargetInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactTargetInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.channelTargetInfo(), other.channelTargetInfo()) && Objects.equals(this.contactTargetInfo(), other.contactTargetInfo());
    }

    public final String toString() {
        return ToString.builder((String)"Target").add("ChannelTargetInfo", (Object)this.channelTargetInfo()).add("ContactTargetInfo", (Object)this.contactTargetInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelTargetInfo": {
                return Optional.ofNullable(clazz.cast(this.channelTargetInfo()));
            }
            case "ContactTargetInfo": {
                return Optional.ofNullable(clazz.cast(this.contactTargetInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ChannelTargetInfo channelTargetInfo;
        private ContactTargetInfo contactTargetInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.channelTargetInfo(model.channelTargetInfo);
            this.contactTargetInfo(model.contactTargetInfo);
        }

        public final ChannelTargetInfo.Builder getChannelTargetInfo() {
            return this.channelTargetInfo != null ? this.channelTargetInfo.toBuilder() : null;
        }

        @Override
        public final Builder channelTargetInfo(ChannelTargetInfo channelTargetInfo) {
            this.channelTargetInfo = channelTargetInfo;
            return this;
        }

        public final void setChannelTargetInfo(ChannelTargetInfo.BuilderImpl channelTargetInfo) {
            this.channelTargetInfo = channelTargetInfo != null ? channelTargetInfo.build() : null;
        }

        public final ContactTargetInfo.Builder getContactTargetInfo() {
            return this.contactTargetInfo != null ? this.contactTargetInfo.toBuilder() : null;
        }

        @Override
        public final Builder contactTargetInfo(ContactTargetInfo contactTargetInfo) {
            this.contactTargetInfo = contactTargetInfo;
            return this;
        }

        public final void setContactTargetInfo(ContactTargetInfo.BuilderImpl contactTargetInfo) {
            this.contactTargetInfo = contactTargetInfo != null ? contactTargetInfo.build() : null;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder channelTargetInfo(ChannelTargetInfo var1);

        default public Builder channelTargetInfo(Consumer<ChannelTargetInfo.Builder> channelTargetInfo) {
            return this.channelTargetInfo((ChannelTargetInfo)((ChannelTargetInfo.Builder)ChannelTargetInfo.builder().applyMutation(channelTargetInfo)).build());
        }

        public Builder contactTargetInfo(ContactTargetInfo var1);

        default public Builder contactTargetInfo(Consumer<ContactTargetInfo.Builder> contactTargetInfo) {
            return this.contactTargetInfo((ContactTargetInfo)((ContactTargetInfo.Builder)ContactTargetInfo.builder().applyMutation(contactTargetInfo)).build());
        }
    }
}

