/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.Engagement;
import software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse;

public class ListEngagementsIterable
implements SdkIterable<ListEngagementsResponse> {
    private final SsmContactsClient client;
    private final ListEngagementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngagementsIterable(SsmContactsClient client, ListEngagementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEngagementsResponseFetcher();
    }

    public Iterator<ListEngagementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Engagement> engagements() {
        Function<ListEngagementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagements() != null) {
                return response.engagements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngagementsResponseFetcher
    implements SyncPageFetcher<ListEngagementsResponse> {
        private ListEngagementsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngagementsResponse nextPage(ListEngagementsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementsIterable.this.client.listEngagements(ListEngagementsIterable.this.firstRequest);
            }
            return ListEngagementsIterable.this.client.listEngagements((ListEngagementsRequest)((Object)ListEngagementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

