/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.AcceptCodeValidation;
import software.amazon.awssdk.services.ssmcontacts.model.AcceptType;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptPageRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, AcceptPageRequest> {
    private static final SdkField<String> PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageId").getter(AcceptPageRequest.getter(AcceptPageRequest::pageId)).setter(AcceptPageRequest.setter(Builder::pageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageId").build()}).build();
    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactChannelId").getter(AcceptPageRequest.getter(AcceptPageRequest::contactChannelId)).setter(AcceptPageRequest.setter(Builder::contactChannelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()}).build();
    private static final SdkField<String> ACCEPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptType").getter(AcceptPageRequest.getter(AcceptPageRequest::acceptTypeAsString)).setter(AcceptPageRequest.setter(Builder::acceptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptType").build()}).build();
    private static final SdkField<String> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Note").getter(AcceptPageRequest.getter(AcceptPageRequest::note)).setter(AcceptPageRequest.setter(Builder::note)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()}).build();
    private static final SdkField<String> ACCEPT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptCode").getter(AcceptPageRequest.getter(AcceptPageRequest::acceptCode)).setter(AcceptPageRequest.setter(Builder::acceptCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptCode").build()}).build();
    private static final SdkField<String> ACCEPT_CODE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptCodeValidation").getter(AcceptPageRequest.getter(AcceptPageRequest::acceptCodeValidationAsString)).setter(AcceptPageRequest.setter(Builder::acceptCodeValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptCodeValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_ID_FIELD, CONTACT_CHANNEL_ID_FIELD, ACCEPT_TYPE_FIELD, NOTE_FIELD, ACCEPT_CODE_FIELD, ACCEPT_CODE_VALIDATION_FIELD));
    private final String pageId;
    private final String contactChannelId;
    private final String acceptType;
    private final String note;
    private final String acceptCode;
    private final String acceptCodeValidation;

    private AcceptPageRequest(BuilderImpl builder) {
        super(builder);
        this.pageId = builder.pageId;
        this.contactChannelId = builder.contactChannelId;
        this.acceptType = builder.acceptType;
        this.note = builder.note;
        this.acceptCode = builder.acceptCode;
        this.acceptCodeValidation = builder.acceptCodeValidation;
    }

    public final String pageId() {
        return this.pageId;
    }

    public final String contactChannelId() {
        return this.contactChannelId;
    }

    public final AcceptType acceptType() {
        return AcceptType.fromValue(this.acceptType);
    }

    public final String acceptTypeAsString() {
        return this.acceptType;
    }

    public final String note() {
        return this.note;
    }

    public final String acceptCode() {
        return this.acceptCode;
    }

    public final AcceptCodeValidation acceptCodeValidation() {
        return AcceptCodeValidation.fromValue(this.acceptCodeValidation);
    }

    public final String acceptCodeValidationAsString() {
        return this.acceptCodeValidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptCodeValidationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPageRequest)) {
            return false;
        }
        AcceptPageRequest other = (AcceptPageRequest)((Object)obj);
        return Objects.equals(this.pageId(), other.pageId()) && Objects.equals(this.contactChannelId(), other.contactChannelId()) && Objects.equals(this.acceptTypeAsString(), other.acceptTypeAsString()) && Objects.equals(this.note(), other.note()) && Objects.equals(this.acceptCode(), other.acceptCode()) && Objects.equals(this.acceptCodeValidationAsString(), other.acceptCodeValidationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptPageRequest").add("PageId", (Object)this.pageId()).add("ContactChannelId", (Object)this.contactChannelId()).add("AcceptType", (Object)this.acceptTypeAsString()).add("Note", (Object)this.note()).add("AcceptCode", (Object)this.acceptCode()).add("AcceptCodeValidation", (Object)this.acceptCodeValidationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PageId": {
                return Optional.ofNullable(clazz.cast(this.pageId()));
            }
            case "ContactChannelId": {
                return Optional.ofNullable(clazz.cast(this.contactChannelId()));
            }
            case "AcceptType": {
                return Optional.ofNullable(clazz.cast(this.acceptTypeAsString()));
            }
            case "Note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "AcceptCode": {
                return Optional.ofNullable(clazz.cast(this.acceptCode()));
            }
            case "AcceptCodeValidation": {
                return Optional.ofNullable(clazz.cast(this.acceptCodeValidationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptPageRequest, T> g) {
        return obj -> g.apply((AcceptPageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String pageId;
        private String contactChannelId;
        private String acceptType;
        private String note;
        private String acceptCode;
        private String acceptCodeValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPageRequest model) {
            super(model);
            this.pageId(model.pageId);
            this.contactChannelId(model.contactChannelId);
            this.acceptType(model.acceptType);
            this.note(model.note);
            this.acceptCode(model.acceptCode);
            this.acceptCodeValidation(model.acceptCodeValidation);
        }

        public final String getPageId() {
            return this.pageId;
        }

        @Override
        public final Builder pageId(String pageId) {
            this.pageId = pageId;
            return this;
        }

        public final void setPageId(String pageId) {
            this.pageId = pageId;
        }

        public final String getContactChannelId() {
            return this.contactChannelId;
        }

        @Override
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        public final String getAcceptType() {
            return this.acceptType;
        }

        @Override
        public final Builder acceptType(String acceptType) {
            this.acceptType = acceptType;
            return this;
        }

        @Override
        public final Builder acceptType(AcceptType acceptType) {
            this.acceptType(acceptType == null ? null : acceptType.toString());
            return this;
        }

        public final void setAcceptType(String acceptType) {
            this.acceptType = acceptType;
        }

        public final String getNote() {
            return this.note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public final String getAcceptCode() {
            return this.acceptCode;
        }

        @Override
        public final Builder acceptCode(String acceptCode) {
            this.acceptCode = acceptCode;
            return this;
        }

        public final void setAcceptCode(String acceptCode) {
            this.acceptCode = acceptCode;
        }

        public final String getAcceptCodeValidation() {
            return this.acceptCodeValidation;
        }

        @Override
        public final Builder acceptCodeValidation(String acceptCodeValidation) {
            this.acceptCodeValidation = acceptCodeValidation;
            return this;
        }

        @Override
        public final Builder acceptCodeValidation(AcceptCodeValidation acceptCodeValidation) {
            this.acceptCodeValidation(acceptCodeValidation == null ? null : acceptCodeValidation.toString());
            return this;
        }

        public final void setAcceptCodeValidation(String acceptCodeValidation) {
            this.acceptCodeValidation = acceptCodeValidation;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptPageRequest build() {
            return new AcceptPageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptPageRequest> {
        public Builder pageId(String var1);

        public Builder contactChannelId(String var1);

        public Builder acceptType(String var1);

        public Builder acceptType(AcceptType var1);

        public Builder note(String var1);

        public Builder acceptCode(String var1);

        public Builder acceptCodeValidation(String var1);

        public Builder acceptCodeValidation(AcceptCodeValidation var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

