/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.Stage;
import software.amazon.awssdk.services.ssmcontacts.model.StagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Plan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Plan> {
    private static final SdkField<List<Stage>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stages").getter(Plan.getter(Plan::stages)).setter(Plan.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Stage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Stage> stages;

    private Plan(BuilderImpl builder) {
        this.stages = builder.stages;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<Stage> stages() {
        return this.stages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)obj;
        return this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages());
    }

    public final String toString() {
        return ToString.builder((String)"Plan").add("Stages", this.hasStages() ? this.stages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Plan, T> g) {
        return obj -> g.apply((Plan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Stage> stages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Plan model) {
            this.stages(model.stages);
        }

        public final List<Stage.Builder> getStages() {
            List<Stage.Builder> result = StagesListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stages(Collection<Stage> stages) {
            this.stages = StagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Stage ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<Stage.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (Stage)((Stage.Builder)Stage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStages(Collection<Stage.BuilderImpl> stages) {
            this.stages = StagesListCopier.copyFromBuilder(stages);
        }

        public Plan build() {
            return new Plan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Plan> {
        public Builder stages(Collection<Stage> var1);

        public Builder stages(Stage ... var1);

        public Builder stages(Consumer<Stage.Builder> ... var1);
    }
}

