/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReceiptType {
    DELIVERED("DELIVERED"),
    ERROR("ERROR"),
    READ("READ"),
    SENT("SENT"),
    STOP("STOP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReceiptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReceiptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReceiptType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReceiptType> knownValues() {
        return Stream.of(ReceiptType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

