/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchRule;
import software.amazon.awssdk.services.ssm.model.PatchRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchRuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchRuleGroup> {
    private static final SdkField<List<PatchRule>> PATCH_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PatchRuleGroup.getter(PatchRuleGroup::patchRules)).setter(PatchRuleGroup.setter(Builder::patchRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    public List<PatchRule> patchRules() {
        return this.patchRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup)obj;
        return Objects.equals(this.patchRules(), other.patchRules());
    }

    public String toString() {
        return ToString.builder((String)"PatchRuleGroup").add("PatchRules", this.patchRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchRules": {
                return Optional.ofNullable(clazz.cast(this.patchRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchRuleGroup, T> g) {
        return obj -> g.apply((PatchRuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchRule> patchRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            this.patchRules(model.patchRules);
        }

        public final Collection<PatchRule.Builder> getPatchRules() {
            return this.patchRules != null ? (Collection)this.patchRules.stream().map(PatchRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule ... patchRules) {
            this.patchRules(Arrays.asList(patchRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(Consumer<PatchRule.Builder> ... patchRules) {
            this.patchRules(Stream.of(patchRules).map(c -> (PatchRule)((PatchRule.Builder)PatchRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchRules(Collection<PatchRule.BuilderImpl> patchRules) {
            this.patchRules = PatchRuleListCopier.copyFromBuilder(patchRules);
        }

        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchRuleGroup> {
        public Builder patchRules(Collection<PatchRule> var1);

        public Builder patchRules(PatchRule ... var1);

        public Builder patchRules(Consumer<PatchRule.Builder> ... var1);
    }
}

