/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchRule;
import software.amazon.awssdk.services.ssm.model.PatchRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchRuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchRuleGroup> {
    private static final SdkField<List<PatchRule>> PATCH_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PatchRules").getter(PatchRuleGroup.getter(PatchRuleGroup::patchRules)).setter(PatchRuleGroup.setter(Builder::patchRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PatchRuleGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    public final boolean hasPatchRules() {
        return this.patchRules != null && !(this.patchRules instanceof SdkAutoConstructList);
    }

    public final List<PatchRule> patchRules() {
        return this.patchRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatchRules() ? this.patchRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup)obj;
        return this.hasPatchRules() == other.hasPatchRules() && Objects.equals(this.patchRules(), other.patchRules());
    }

    public final String toString() {
        return ToString.builder((String)"PatchRuleGroup").add("PatchRules", this.hasPatchRules() ? this.patchRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchRules": {
                return Optional.ofNullable(clazz.cast(this.patchRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PatchRule>>> map = new HashMap<String, SdkField<List<PatchRule>>>();
        map.put("PatchRules", PATCH_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PatchRuleGroup, T> g) {
        return obj -> g.apply((PatchRuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchRule> patchRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            this.patchRules(model.patchRules);
        }

        public final List<PatchRule.Builder> getPatchRules() {
            List<PatchRule.Builder> result = PatchRuleListCopier.copyToBuilder(this.patchRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatchRules(Collection<PatchRule.BuilderImpl> patchRules) {
            this.patchRules = PatchRuleListCopier.copyFromBuilder(patchRules);
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule ... patchRules) {
            this.patchRules(Arrays.asList(patchRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(Consumer<PatchRule.Builder> ... patchRules) {
            this.patchRules(Stream.of(patchRules).map(c -> (PatchRule)((PatchRule.Builder)PatchRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchRuleGroup> {
        public Builder patchRules(Collection<PatchRule> var1);

        public Builder patchRules(PatchRule ... var1);

        public Builder patchRules(Consumer<PatchRule.Builder> ... var1);
    }
}

