/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessRequestStatus {
    APPROVED("Approved"),
    REJECTED("Rejected"),
    REVOKED("Revoked"),
    EXPIRED("Expired"),
    PENDING("Pending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessRequestStatus> VALUE_MAP;
    private final String value;

    private AccessRequestStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessRequestStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessRequestStatus> knownValues() {
        EnumSet<AccessRequestStatus> knownValues = EnumSet.allOf(AccessRequestStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessRequestStatus.class, AccessRequestStatus::toString);
    }
}

