/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActivationsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeActivationsResponse.Builder, DescribeActivationsResponse> {
    private static final SdkField<List<Activation>> ACTIVATION_LIST_FIELD = SdkField
            .<List<Activation>> builder(MarshallingType.LIST)
            .memberName("ActivationList")
            .getter(getter(DescribeActivationsResponse::activationList))
            .setter(setter(Builder::activationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Activation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Activation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeActivationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Activation> activationList;

    private final String nextToken;

    private DescribeActivationsResponse(BuilderImpl builder) {
        super(builder);
        this.activationList = builder.activationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActivationList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActivationList() {
        return activationList != null && !(activationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of activations for your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivationList} method.
     * </p>
     * 
     * @return A list of activations for your Amazon Web Services account.
     */
    public final List<Activation> activationList() {
        return activationList;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActivationList() ? activationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsResponse)) {
            return false;
        }
        DescribeActivationsResponse other = (DescribeActivationsResponse) obj;
        return hasActivationList() == other.hasActivationList() && Objects.equals(activationList(), other.activationList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActivationsResponse")
                .add("ActivationList", hasActivationList() ? activationList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationList":
            return Optional.ofNullable(clazz.cast(activationList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActivationList", ACTIVATION_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivationsResponse, T> g) {
        return obj -> g.apply((DescribeActivationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActivationsResponse> {
        /**
         * <p>
         * A list of activations for your Amazon Web Services account.
         * </p>
         * 
         * @param activationList
         *        A list of activations for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationList(Collection<Activation> activationList);

        /**
         * <p>
         * A list of activations for your Amazon Web Services account.
         * </p>
         * 
         * @param activationList
         *        A list of activations for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationList(Activation... activationList);

        /**
         * <p>
         * A list of activations for your Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Activation.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ssm.model.Activation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.Activation.Builder#build()} is called immediately and its
         * result is passed to {@link #activationList(List<Activation>)}.
         * 
         * @param activationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.Activation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activationList(java.util.Collection<Activation>)
         */
        Builder activationList(Consumer<Activation.Builder>... activationList);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<Activation> activationList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsResponse model) {
            super(model);
            activationList(model.activationList);
            nextToken(model.nextToken);
        }

        public final List<Activation.Builder> getActivationList() {
            List<Activation.Builder> result = ActivationListCopier.copyToBuilder(this.activationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivationList(Collection<Activation.BuilderImpl> activationList) {
            this.activationList = ActivationListCopier.copyFromBuilder(activationList);
        }

        @Override
        public final Builder activationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Activation... activationList) {
            activationList(Arrays.asList(activationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Consumer<Activation.Builder>... activationList) {
            activationList(Stream.of(activationList).map(c -> Activation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeActivationsResponse build() {
            return new DescribeActivationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
