/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancePatchesResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeInstancePatchesResponse.Builder, DescribeInstancePatchesResponse> {
    private static final SdkField<List<PatchComplianceData>> PATCHES_FIELD = SdkField
            .<List<PatchComplianceData>> builder(MarshallingType.LIST)
            .memberName("Patches")
            .getter(getter(DescribeInstancePatchesResponse::patches))
            .setter(setter(Builder::patches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchComplianceData> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchComplianceData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstancePatchesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCHES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PatchComplianceData> patches;

    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Patches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPatches() {
        return patches != null && !(patches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Title (string)
     * </p>
     * </li>
     * <li>
     * <p>
     * KBId (string)
     * </p>
     * </li>
     * <li>
     * <p>
     * Classification (string)
     * </p>
     * </li>
     * <li>
     * <p>
     * Severity (string)
     * </p>
     * </li>
     * <li>
     * <p>
     * State (string, such as "INSTALLED" or "FAILED")
     * </p>
     * </li>
     * <li>
     * <p>
     * InstalledTime (DateTime)
     * </p>
     * </li>
     * <li>
     * <p>
     * InstalledBy (string)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatches} method.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Title (string)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KBId (string)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Classification (string)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Severity (string)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         State (string, such as "INSTALLED" or "FAILED")
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InstalledTime (DateTime)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InstalledBy (string)
     *         </p>
     *         </li>
     */
    public final List<PatchComplianceData> patches() {
        return patches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPatches() ? patches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse) obj;
        return hasPatches() == other.hasPatches() && Objects.equals(patches(), other.patches())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancePatchesResponse").add("Patches", hasPatches() ? patches() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patches":
            return Optional.ofNullable(clazz.cast(patches()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Patches", PATCHES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePatchesResponse, T> g) {
        return obj -> g.apply((DescribeInstancePatchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Title (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * KBId (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Classification (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Severity (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * State (string, such as "INSTALLED" or "FAILED")
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledBy (string)
         * </p>
         * </li>
         * </ul>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Title (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KBId (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Classification (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Severity (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        State (string, such as "INSTALLED" or "FAILED")
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InstalledBy (string)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Collection<PatchComplianceData> patches);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Title (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * KBId (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Classification (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Severity (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * State (string, such as "INSTALLED" or "FAILED")
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledBy (string)
         * </p>
         * </li>
         * </ul>
         * 
         * @param patches
         *        Each entry in the array is a structure containing:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Title (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KBId (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Classification (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Severity (string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        State (string, such as "INSTALLED" or "FAILED")
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InstalledTime (DateTime)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InstalledBy (string)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(PatchComplianceData... patches);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Title (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * KBId (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Classification (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Severity (string)
         * </p>
         * </li>
         * <li>
         * <p>
         * State (string, such as "INSTALLED" or "FAILED")
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledTime (DateTime)
         * </p>
         * </li>
         * <li>
         * <p>
         * InstalledBy (string)
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.PatchComplianceData.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.PatchComplianceData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.PatchComplianceData.Builder#build()} is called immediately
         * and its result is passed to {@link #patches(List<PatchComplianceData>)}.
         * 
         * @param patches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.PatchComplianceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patches(java.util.Collection<PatchComplianceData>)
         */
        Builder patches(Consumer<PatchComplianceData.Builder>... patches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<PatchComplianceData> patches = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            super(model);
            patches(model.patches);
            nextToken(model.nextToken);
        }

        public final List<PatchComplianceData.Builder> getPatches() {
            List<PatchComplianceData.Builder> result = PatchComplianceDataListCopier.copyToBuilder(this.patches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatches(Collection<PatchComplianceData.BuilderImpl> patches) {
            this.patches = PatchComplianceDataListCopier.copyFromBuilder(patches);
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData... patches) {
            patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Consumer<PatchComplianceData.Builder>... patches) {
            patches(Stream.of(patches).map(c -> PatchComplianceData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
