/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.AccessRequestStatus;
import software.amazon.awssdk.services.ssm.model.Credentials;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessTokenResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetAccessTokenResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(GetAccessTokenResponse.getter(GetAccessTokenResponse::credentials)).setter(GetAccessTokenResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> ACCESS_REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRequestStatus").getter(GetAccessTokenResponse.getter(GetAccessTokenResponse::accessRequestStatusAsString)).setter(GetAccessTokenResponse.setter(Builder::accessRequestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRequestStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, ACCESS_REQUEST_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccessTokenResponse.memberNameToFieldInitializer();
    private final Credentials credentials;
    private final String accessRequestStatus;

    private GetAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.accessRequestStatus = builder.accessRequestStatus;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final AccessRequestStatus accessRequestStatus() {
        return AccessRequestStatus.fromValue(this.accessRequestStatus);
    }

    public final String accessRequestStatusAsString() {
        return this.accessRequestStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRequestStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessTokenResponse)) {
            return false;
        }
        GetAccessTokenResponse other = (GetAccessTokenResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.accessRequestStatusAsString(), other.accessRequestStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessTokenResponse").add("Credentials", (Object)this.credentials()).add("AccessRequestStatus", (Object)this.accessRequestStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "AccessRequestStatus": {
                return Optional.ofNullable(clazz.cast(this.accessRequestStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("AccessRequestStatus", ACCESS_REQUEST_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessTokenResponse, T> g) {
        return obj -> g.apply((GetAccessTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String accessRequestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessTokenResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.accessRequestStatus(model.accessRequestStatus);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getAccessRequestStatus() {
            return this.accessRequestStatus;
        }

        public final void setAccessRequestStatus(String accessRequestStatus) {
            this.accessRequestStatus = accessRequestStatus;
        }

        @Override
        public final Builder accessRequestStatus(String accessRequestStatus) {
            this.accessRequestStatus = accessRequestStatus;
            return this;
        }

        @Override
        public final Builder accessRequestStatus(AccessRequestStatus accessRequestStatus) {
            this.accessRequestStatus(accessRequestStatus == null ? null : accessRequestStatus.toString());
            return this;
        }

        @Override
        public GetAccessTokenResponse build() {
            return new GetAccessTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessTokenResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder accessRequestStatus(String var1);

        public Builder accessRequestStatus(AccessRequestStatus var1);
    }
}

