/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.InventoryGroup;
import software.amazon.awssdk.services.ssm.model.InventoryGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryAggregator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryAggregator> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(InventoryAggregator.getter(InventoryAggregator::expression)).setter(InventoryAggregator.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<List<InventoryAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(InventoryAggregator.getter(InventoryAggregator::aggregators)).setter(InventoryAggregator.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InventoryGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(InventoryAggregator.getter(InventoryAggregator::groups)).setter(InventoryAggregator.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, AGGREGATORS_FIELD, GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InventoryAggregator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final List<InventoryAggregator> aggregators;
    private final List<InventoryGroup> groups;

    private InventoryAggregator(BuilderImpl builder) {
        this.expression = builder.expression;
        this.aggregators = builder.aggregators;
        this.groups = builder.groups;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public final List<InventoryAggregator> aggregators() {
        return this.aggregators;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<InventoryGroup> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryAggregator)) {
            return false;
        }
        InventoryAggregator other = (InventoryAggregator)obj;
        return Objects.equals(this.expression(), other.expression()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryAggregator").add("Expression", (Object)this.expression()).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).add("Groups", this.hasGroups() ? this.groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Aggregators", AGGREGATORS_FIELD);
        map.put("Groups", GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryAggregator, T> g) {
        return obj -> g.apply((InventoryAggregator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private List<InventoryAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();
        private List<InventoryGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryAggregator model) {
            this.expression(model.expression);
            this.aggregators(model.aggregators);
            this.groups(model.groups);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = InventoryAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (InventoryAggregator)((Builder)InventoryAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InventoryGroup.Builder> getGroups() {
            List<InventoryGroup.Builder> result = InventoryGroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<InventoryGroup.BuilderImpl> groups) {
            this.groups = InventoryGroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<InventoryGroup> groups) {
            this.groups = InventoryGroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(InventoryGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<InventoryGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (InventoryGroup)((InventoryGroup.Builder)InventoryGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InventoryAggregator build() {
            return new InventoryAggregator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryAggregator> {
        public Builder expression(String var1);

        public Builder aggregators(Collection<InventoryAggregator> var1);

        public Builder aggregators(InventoryAggregator ... var1);

        public Builder aggregators(Consumer<Builder> ... var1);

        public Builder groups(Collection<InventoryGroup> var1);

        public Builder groups(InventoryGroup ... var1);

        public Builder groups(Consumer<InventoryGroup.Builder> ... var1);
    }
}

