/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowIdentity> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::windowId)).setter(MaintenanceWindowIdentity.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::name)).setter(MaintenanceWindowIdentity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::description)).setter(MaintenanceWindowIdentity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::enabled)).setter(MaintenanceWindowIdentity.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::duration)).setter(MaintenanceWindowIdentity.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cutoff").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::cutoff)).setter(MaintenanceWindowIdentity.setter(Builder::cutoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::schedule)).setter(MaintenanceWindowIdentity.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleTimezone").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::scheduleTimezone)).setter(MaintenanceWindowIdentity.setter(Builder::scheduleTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduleOffset").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::scheduleOffset)).setter(MaintenanceWindowIdentity.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDate").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::endDate)).setter(MaintenanceWindowIdentity.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDate").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::startDate)).setter(MaintenanceWindowIdentity.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> NEXT_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextExecutionTime").getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::nextExecutionTime)).setter(MaintenanceWindowIdentity.setter(Builder::nextExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextExecutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, DURATION_FIELD, CUTOFF_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, END_DATE_FIELD, START_DATE_FIELD, NEXT_EXECUTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WindowId", WINDOW_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("Duration", DURATION_FIELD);
            this.put("Cutoff", CUTOFF_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("ScheduleTimezone", SCHEDULE_TIMEZONE_FIELD);
            this.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
            this.put("EndDate", END_DATE_FIELD);
            this.put("StartDate", START_DATE_FIELD);
            this.put("NextExecutionTime", NEXT_EXECUTION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String name;
    private final String description;
    private final Boolean enabled;
    private final Integer duration;
    private final Integer cutoff;
    private final String schedule;
    private final String scheduleTimezone;
    private final Integer scheduleOffset;
    private final String endDate;
    private final String startDate;
    private final String nextExecutionTime;

    private MaintenanceWindowIdentity(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.endDate = builder.endDate;
        this.startDate = builder.startDate;
        this.nextExecutionTime = builder.nextExecutionTime;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Integer cutoff() {
        return this.cutoff;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final String scheduleTimezone() {
        return this.scheduleTimezone;
    }

    public final Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public final String endDate() {
        return this.endDate;
    }

    public final String startDate() {
        return this.startDate;
    }

    public final String nextExecutionTime() {
        return this.nextExecutionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextExecutionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowIdentity)) {
            return false;
        }
        MaintenanceWindowIdentity other = (MaintenanceWindowIdentity)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduleTimezone(), other.scheduleTimezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.nextExecutionTime(), other.nextExecutionTime());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowIdentity").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Enabled", (Object)this.enabled()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("Schedule", (Object)this.schedule()).add("ScheduleTimezone", (Object)this.scheduleTimezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("EndDate", (Object)this.endDate()).add("StartDate", (Object)this.startDate()).add("NextExecutionTime", (Object)this.nextExecutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduleTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleTimezone()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "NextExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.nextExecutionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private Boolean enabled;
        private Integer duration;
        private Integer cutoff;
        private String schedule;
        private String scheduleTimezone;
        private Integer scheduleOffset;
        private String endDate;
        private String startDate;
        private String nextExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowIdentity model) {
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.enabled(model.enabled);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.schedule(model.schedule);
            this.scheduleTimezone(model.scheduleTimezone);
            this.scheduleOffset(model.scheduleOffset);
            this.endDate(model.endDate);
            this.startDate(model.startDate);
            this.nextExecutionTime(model.nextExecutionTime);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduleTimezone() {
            return this.scheduleTimezone;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getNextExecutionTime() {
            return this.nextExecutionTime;
        }

        public final void setNextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        @Override
        public final Builder nextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
            return this;
        }

        public MaintenanceWindowIdentity build() {
            return new MaintenanceWindowIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowIdentity> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder schedule(String var1);

        public Builder scheduleTimezone(String var1);

        public Builder scheduleOffset(Integer var1);

        public Builder endDate(String var1);

        public Builder startDate(String var1);

        public Builder nextExecutionTime(String var1);
    }
}

