/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsMetadata> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(OpsMetadata.getter(OpsMetadata::resourceId)).setter(OpsMetadata.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> OPS_METADATA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsMetadataArn").getter(OpsMetadata.getter(OpsMetadata::opsMetadataArn)).setter(OpsMetadata.setter(Builder::opsMetadataArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(OpsMetadata.getter(OpsMetadata::lastModifiedDate)).setter(OpsMetadata.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedUser").getter(OpsMetadata.getter(OpsMetadata::lastModifiedUser)).setter(OpsMetadata.setter(Builder::lastModifiedUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedUser").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(OpsMetadata.getter(OpsMetadata::creationDate)).setter(OpsMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, OPS_METADATA_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_USER_FIELD, CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpsMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String opsMetadataArn;
    private final Instant lastModifiedDate;
    private final String lastModifiedUser;
    private final Instant creationDate;

    private OpsMetadata(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.opsMetadataArn = builder.opsMetadataArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.creationDate = builder.creationDate;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String opsMetadataArn() {
        return this.opsMetadataArn;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsMetadataArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsMetadata)) {
            return false;
        }
        OpsMetadata other = (OpsMetadata)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.opsMetadataArn(), other.opsMetadataArn()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"OpsMetadata").add("ResourceId", (Object)this.resourceId()).add("OpsMetadataArn", (Object)this.opsMetadataArn()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "OpsMetadataArn": {
                return Optional.ofNullable(clazz.cast(this.opsMetadataArn()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedUser": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedUser()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("OpsMetadataArn", OPS_METADATA_ARN_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LastModifiedUser", LAST_MODIFIED_USER_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsMetadata, T> g) {
        return obj -> g.apply((OpsMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String opsMetadataArn;
        private Instant lastModifiedDate;
        private String lastModifiedUser;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsMetadata model) {
            this.resourceId(model.resourceId);
            this.opsMetadataArn(model.opsMetadataArn);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.creationDate(model.creationDate);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getOpsMetadataArn() {
            return this.opsMetadataArn;
        }

        public final void setOpsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
        }

        @Override
        public final Builder opsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public OpsMetadata build() {
            return new OpsMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsMetadata> {
        public Builder resourceId(String var1);

        public Builder opsMetadataArn(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder creationDate(Instant var1);
    }
}

