/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AlarmConfiguration;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformation;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformationListCopier;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.AutomationSubtype;
import software.amazon.awssdk.services.ssm.model.ExecutionMode;
import software.amazon.awssdk.services.ssm.model.ProgressCounters;
import software.amazon.awssdk.services.ssm.model.ResolvedTargets;
import software.amazon.awssdk.services.ssm.model.Runbook;
import software.amazon.awssdk.services.ssm.model.RunbooksCopier;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecution> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationExecutionId").getter(AutomationExecution.getter(AutomationExecution::automationExecutionId)).setter(AutomationExecution.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(AutomationExecution.getter(AutomationExecution::documentName)).setter(AutomationExecution.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(AutomationExecution.getter(AutomationExecution::documentVersion)).setter(AutomationExecution.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionStartTime").getter(AutomationExecution.getter(AutomationExecution::executionStartTime)).setter(AutomationExecution.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionEndTime").getter(AutomationExecution.getter(AutomationExecution::executionEndTime)).setter(AutomationExecution.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationExecutionStatus").getter(AutomationExecution.getter(AutomationExecution::automationExecutionStatusAsString)).setter(AutomationExecution.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepExecutions").getter(AutomationExecution.getter(AutomationExecution::stepExecutions)).setter(AutomationExecution.setter(Builder::stepExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STEP_EXECUTIONS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StepExecutionsTruncated").getter(AutomationExecution.getter(AutomationExecution::stepExecutionsTruncated)).setter(AutomationExecution.setter(Builder::stepExecutionsTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutionsTruncated").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(AutomationExecution.getter(AutomationExecution::parameters)).setter(AutomationExecution.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Outputs").getter(AutomationExecution.getter(AutomationExecution::outputs)).setter(AutomationExecution.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(AutomationExecution.getter(AutomationExecution::failureMessage)).setter(AutomationExecution.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(AutomationExecution.getter(AutomationExecution::modeAsString)).setter(AutomationExecution.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentAutomationExecutionId").getter(AutomationExecution.getter(AutomationExecution::parentAutomationExecutionId)).setter(AutomationExecution.setter(Builder::parentAutomationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId").build()}).build();
    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutedBy").getter(AutomationExecution.getter(AutomationExecution::executedBy)).setter(AutomationExecution.setter(Builder::executedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()}).build();
    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentStepName").getter(AutomationExecution.getter(AutomationExecution::currentStepName)).setter(AutomationExecution.setter(Builder::currentStepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()}).build();
    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAction").getter(AutomationExecution.getter(AutomationExecution::currentAction)).setter(AutomationExecution.setter(Builder::currentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetParameterName").getter(AutomationExecution.getter(AutomationExecution::targetParameterName)).setter(AutomationExecution.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(AutomationExecution.getter(AutomationExecution::targets)).setter(AutomationExecution.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(AutomationExecution.getter(AutomationExecution::targetMaps)).setter(AutomationExecution.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResolvedTargets").getter(AutomationExecution.getter(AutomationExecution::resolvedTargets)).setter(AutomationExecution.setter(Builder::resolvedTargets)).constructor(ResolvedTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(AutomationExecution.getter(AutomationExecution::maxConcurrency)).setter(AutomationExecution.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(AutomationExecution.getter(AutomationExecution::maxErrors)).setter(AutomationExecution.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(AutomationExecution.getter(AutomationExecution::target)).setter(AutomationExecution.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLocations").getter(AutomationExecution.getter(AutomationExecution::targetLocations)).setter(AutomationExecution.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProgressCounters> PROGRESS_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressCounters").getter(AutomationExecution.getter(AutomationExecution::progressCounters)).setter(AutomationExecution.setter(Builder::progressCounters)).constructor(ProgressCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressCounters").build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmConfiguration").getter(AutomationExecution.getter(AutomationExecution::alarmConfiguration)).setter(AutomationExecution.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build()}).build();
    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggeredAlarms").getter(AutomationExecution.getter(AutomationExecution::triggeredAlarms)).setter(AutomationExecution.setter(Builder::triggeredAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmStateInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTOMATION_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationSubtype").getter(AutomationExecution.getter(AutomationExecution::automationSubtypeAsString)).setter(AutomationExecution.setter(Builder::automationSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationSubtype").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(AutomationExecution.getter(AutomationExecution::scheduledTime)).setter(AutomationExecution.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<List<Runbook>> RUNBOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Runbooks").getter(AutomationExecution.getter(AutomationExecution::runbooks)).setter(AutomationExecution.setter(Builder::runbooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runbooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Runbook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(AutomationExecution.getter(AutomationExecution::opsItemId)).setter(AutomationExecution.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AutomationExecution.getter(AutomationExecution::associationId)).setter(AutomationExecution.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> CHANGE_REQUEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeRequestName").getter(AutomationExecution.getter(AutomationExecution::changeRequestName)).setter(AutomationExecution.setter(Builder::changeRequestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeRequestName").build()}).build();
    private static final SdkField<Map<String, List<String>>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(AutomationExecution.getter(AutomationExecution::variables)).setter(AutomationExecution.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, STEP_EXECUTIONS_FIELD, STEP_EXECUTIONS_TRUNCATED_FIELD, PARAMETERS_FIELD, OUTPUTS_FIELD, FAILURE_MESSAGE_FIELD, MODE_FIELD, PARENT_AUTOMATION_EXECUTION_ID_FIELD, EXECUTED_BY_FIELD, CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_FIELD, TARGET_LOCATIONS_FIELD, PROGRESS_COUNTERS_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD, AUTOMATION_SUBTYPE_FIELD, SCHEDULED_TIME_FIELD, RUNBOOKS_FIELD, OPS_ITEM_ID_FIELD, ASSOCIATION_ID_FIELD, CHANGE_REQUEST_NAME_FIELD, VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String automationExecutionStatus;
    private final List<StepExecution> stepExecutions;
    private final Boolean stepExecutionsTruncated;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> outputs;
    private final String failureMessage;
    private final String mode;
    private final String parentAutomationExecutionId;
    private final String executedBy;
    private final String currentStepName;
    private final String currentAction;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final ResolvedTargets resolvedTargets;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String target;
    private final List<TargetLocation> targetLocations;
    private final ProgressCounters progressCounters;
    private final AlarmConfiguration alarmConfiguration;
    private final List<AlarmStateInformation> triggeredAlarms;
    private final String automationSubtype;
    private final Instant scheduledTime;
    private final List<Runbook> runbooks;
    private final String opsItemId;
    private final String associationId;
    private final String changeRequestName;
    private final Map<String, List<String>> variables;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.stepExecutionsTruncated = builder.stepExecutionsTruncated;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.executedBy = builder.executedBy;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.targetLocations = builder.targetLocations;
        this.progressCounters = builder.progressCounters;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
        this.automationSubtype = builder.automationSubtype;
        this.scheduledTime = builder.scheduledTime;
        this.runbooks = builder.runbooks;
        this.opsItemId = builder.opsItemId;
        this.associationId = builder.associationId;
        this.changeRequestName = builder.changeRequestName;
        this.variables = builder.variables;
    }

    public final String automationExecutionId() {
        return this.automationExecutionId;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final Instant executionStartTime() {
        return this.executionStartTime;
    }

    public final Instant executionEndTime() {
        return this.executionEndTime;
    }

    public final AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public final String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public final boolean hasStepExecutions() {
        return this.stepExecutions != null && !(this.stepExecutions instanceof SdkAutoConstructList);
    }

    public final List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public final Boolean stepExecutionsTruncated() {
        return this.stepExecutionsTruncated;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String parentAutomationExecutionId() {
        return this.parentAutomationExecutionId;
    }

    public final String executedBy() {
        return this.executedBy;
    }

    public final String currentStepName() {
        return this.currentStepName;
    }

    public final String currentAction() {
        return this.currentAction;
    }

    public final String targetParameterName() {
        return this.targetParameterName;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final ResolvedTargets resolvedTargets() {
        return this.resolvedTargets;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final String target() {
        return this.target;
    }

    public final boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public final List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public final ProgressCounters progressCounters() {
        return this.progressCounters;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final boolean hasTriggeredAlarms() {
        return this.triggeredAlarms != null && !(this.triggeredAlarms instanceof SdkAutoConstructList);
    }

    public final List<AlarmStateInformation> triggeredAlarms() {
        return this.triggeredAlarms;
    }

    public final AutomationSubtype automationSubtype() {
        return AutomationSubtype.fromValue(this.automationSubtype);
    }

    public final String automationSubtypeAsString() {
        return this.automationSubtype;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public final boolean hasRunbooks() {
        return this.runbooks != null && !(this.runbooks instanceof SdkAutoConstructList);
    }

    public final List<Runbook> runbooks() {
        return this.runbooks;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String changeRequestName() {
        return this.changeRequestName;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepExecutions() ? this.stepExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutionsTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLocations() ? this.targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.progressCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarms() ? this.triggeredAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.automationSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunbooks() ? this.runbooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeRequestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && this.hasStepExecutions() == other.hasStepExecutions() && Objects.equals(this.stepExecutions(), other.stepExecutions()) && Objects.equals(this.stepExecutionsTruncated(), other.stepExecutionsTruncated()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.parentAutomationExecutionId(), other.parentAutomationExecutionId()) && Objects.equals(this.executedBy(), other.executedBy()) && Objects.equals(this.currentStepName(), other.currentStepName()) && Objects.equals(this.currentAction(), other.currentAction()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.resolvedTargets(), other.resolvedTargets()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.target(), other.target()) && this.hasTargetLocations() == other.hasTargetLocations() && Objects.equals(this.targetLocations(), other.targetLocations()) && Objects.equals(this.progressCounters(), other.progressCounters()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && this.hasTriggeredAlarms() == other.hasTriggeredAlarms() && Objects.equals(this.triggeredAlarms(), other.triggeredAlarms()) && Objects.equals(this.automationSubtypeAsString(), other.automationSubtypeAsString()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && this.hasRunbooks() == other.hasRunbooks() && Objects.equals(this.runbooks(), other.runbooks()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.changeRequestName(), other.changeRequestName()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationExecution").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("StepExecutions", this.hasStepExecutions() ? this.stepExecutions() : null).add("StepExecutionsTruncated", (Object)this.stepExecutionsTruncated()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("FailureMessage", (Object)this.failureMessage()).add("Mode", (Object)this.modeAsString()).add("ParentAutomationExecutionId", (Object)this.parentAutomationExecutionId()).add("ExecutedBy", (Object)this.executedBy()).add("CurrentStepName", (Object)this.currentStepName()).add("CurrentAction", (Object)this.currentAction()).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.hasTargets() ? this.targets() : null).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("ResolvedTargets", (Object)this.resolvedTargets()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Target", (Object)this.target()).add("TargetLocations", this.hasTargetLocations() ? this.targetLocations() : null).add("ProgressCounters", (Object)this.progressCounters()).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("TriggeredAlarms", this.hasTriggeredAlarms() ? this.triggeredAlarms() : null).add("AutomationSubtype", (Object)this.automationSubtypeAsString()).add("ScheduledTime", (Object)this.scheduledTime()).add("Runbooks", this.hasRunbooks() ? this.runbooks() : null).add("OpsItemId", (Object)this.opsItemId()).add("AssociationId", (Object)this.associationId()).add("ChangeRequestName", (Object)this.changeRequestName()).add("Variables", this.hasVariables() ? this.variables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "StepExecutions": {
                return Optional.ofNullable(clazz.cast(this.stepExecutions()));
            }
            case "StepExecutionsTruncated": {
                return Optional.ofNullable(clazz.cast(this.stepExecutionsTruncated()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ParentAutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.parentAutomationExecutionId()));
            }
            case "ExecutedBy": {
                return Optional.ofNullable(clazz.cast(this.executedBy()));
            }
            case "CurrentStepName": {
                return Optional.ofNullable(clazz.cast(this.currentStepName()));
            }
            case "CurrentAction": {
                return Optional.ofNullable(clazz.cast(this.currentAction()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "ResolvedTargets": {
                return Optional.ofNullable(clazz.cast(this.resolvedTargets()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
            case "ProgressCounters": {
                return Optional.ofNullable(clazz.cast(this.progressCounters()));
            }
            case "AlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "TriggeredAlarms": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarms()));
            }
            case "AutomationSubtype": {
                return Optional.ofNullable(clazz.cast(this.automationSubtypeAsString()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "Runbooks": {
                return Optional.ofNullable(clazz.cast(this.runbooks()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "ChangeRequestName": {
                return Optional.ofNullable(clazz.cast(this.changeRequestName()));
            }
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecution, T> g) {
        return obj -> g.apply((AutomationExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String automationExecutionStatus;
        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();
        private Boolean stepExecutionsTruncated;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String failureMessage;
        private String mode;
        private String parentAutomationExecutionId;
        private String executedBy;
        private String currentStepName;
        private String currentAction;
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private ResolvedTargets resolvedTargets;
        private String maxConcurrency;
        private String maxErrors;
        private String target;
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();
        private ProgressCounters progressCounters;
        private AlarmConfiguration alarmConfiguration;
        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();
        private String automationSubtype;
        private Instant scheduledTime;
        private List<Runbook> runbooks = DefaultSdkAutoConstructList.getInstance();
        private String opsItemId;
        private String associationId;
        private String changeRequestName;
        private Map<String, List<String>> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.stepExecutions(model.stepExecutions);
            this.stepExecutionsTruncated(model.stepExecutionsTruncated);
            this.parameters(model.parameters);
            this.outputs(model.outputs);
            this.failureMessage(model.failureMessage);
            this.mode(model.mode);
            this.parentAutomationExecutionId(model.parentAutomationExecutionId);
            this.executedBy(model.executedBy);
            this.currentStepName(model.currentStepName);
            this.currentAction(model.currentAction);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.resolvedTargets(model.resolvedTargets);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.target(model.target);
            this.targetLocations(model.targetLocations);
            this.progressCounters(model.progressCounters);
            this.alarmConfiguration(model.alarmConfiguration);
            this.triggeredAlarms(model.triggeredAlarms);
            this.automationSubtype(model.automationSubtype);
            this.scheduledTime(model.scheduledTime);
            this.runbooks(model.runbooks);
            this.opsItemId(model.opsItemId);
            this.associationId(model.associationId);
            this.changeRequestName(model.changeRequestName);
            this.variables(model.variables);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus == null ? null : automationExecutionStatus.toString());
            return this;
        }

        public final List<StepExecution.Builder> getStepExecutions() {
            List<StepExecution.Builder> result = StepExecutionListCopier.copyToBuilder(this.stepExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            this.stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder> ... stepExecutions) {
            this.stepExecutions(Stream.of(stepExecutions).map(c -> (StepExecution)((StepExecution.Builder)StepExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStepExecutionsTruncated() {
            return this.stepExecutionsTruncated;
        }

        public final void setStepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
        }

        @Override
        public final Builder stepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            if (this.outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputs;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getParentAutomationExecutionId() {
            return this.parentAutomationExecutionId;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final String getCurrentStepName() {
            return this.currentStepName;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final String getCurrentAction() {
            return this.currentAction;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return this.resolvedTargets != null ? this.resolvedTargets.toBuilder() : null;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProgressCounters.Builder getProgressCounters() {
            return this.progressCounters != null ? this.progressCounters.toBuilder() : null;
        }

        public final void setProgressCounters(ProgressCounters.BuilderImpl progressCounters) {
            this.progressCounters = progressCounters != null ? progressCounters.build() : null;
        }

        @Override
        public final Builder progressCounters(ProgressCounters progressCounters) {
            this.progressCounters = progressCounters;
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
            this.triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... triggeredAlarms) {
            this.triggeredAlarms(Stream.of(triggeredAlarms).map(c -> (AlarmStateInformation)((AlarmStateInformation.Builder)AlarmStateInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAutomationSubtype() {
            return this.automationSubtype;
        }

        public final void setAutomationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
        }

        @Override
        public final Builder automationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
            return this;
        }

        @Override
        public final Builder automationSubtype(AutomationSubtype automationSubtype) {
            this.automationSubtype(automationSubtype == null ? null : automationSubtype.toString());
            return this;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final List<Runbook.Builder> getRunbooks() {
            List<Runbook.Builder> result = RunbooksCopier.copyToBuilder(this.runbooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRunbooks(Collection<Runbook.BuilderImpl> runbooks) {
            this.runbooks = RunbooksCopier.copyFromBuilder(runbooks);
        }

        @Override
        public final Builder runbooks(Collection<Runbook> runbooks) {
            this.runbooks = RunbooksCopier.copy(runbooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Runbook ... runbooks) {
            this.runbooks(Arrays.asList(runbooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Consumer<Runbook.Builder> ... runbooks) {
            this.runbooks(Stream.of(runbooks).map(c -> (Runbook)((Runbook.Builder)Runbook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getChangeRequestName() {
            return this.changeRequestName;
        }

        public final void setChangeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
        }

        @Override
        public final Builder changeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, ? extends Collection<String>> variables) {
            this.variables = AutomationParameterMapCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, ? extends Collection<String>> variables) {
            this.variables = AutomationParameterMapCopier.copy(variables);
            return this;
        }

        public AutomationExecution build() {
            return new AutomationExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecution> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder stepExecutions(Consumer<StepExecution.Builder> ... var1);

        public Builder stepExecutionsTruncated(Boolean var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder failureMessage(String var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder parentAutomationExecutionId(String var1);

        public Builder executedBy(String var1);

        public Builder currentStepName(String var1);

        public Builder currentAction(String var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder resolvedTargets(ResolvedTargets var1);

        default public Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return this.resolvedTargets((ResolvedTargets)((ResolvedTargets.Builder)ResolvedTargets.builder().applyMutation(resolvedTargets)).build());
        }

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder target(String var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder progressCounters(ProgressCounters var1);

        default public Builder progressCounters(Consumer<ProgressCounters.Builder> progressCounters) {
            return this.progressCounters((ProgressCounters)((ProgressCounters.Builder)ProgressCounters.builder().applyMutation(progressCounters)).build());
        }

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder triggeredAlarms(Collection<AlarmStateInformation> var1);

        public Builder triggeredAlarms(AlarmStateInformation ... var1);

        public Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... var1);

        public Builder automationSubtype(String var1);

        public Builder automationSubtype(AutomationSubtype var1);

        public Builder scheduledTime(Instant var1);

        public Builder runbooks(Collection<Runbook> var1);

        public Builder runbooks(Runbook ... var1);

        public Builder runbooks(Consumer<Runbook.Builder> ... var1);

        public Builder opsItemId(String var1);

        public Builder associationId(String var1);

        public Builder changeRequestName(String var1);

        public Builder variables(Map<String, ? extends Collection<String>> var1);
    }
}

