/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpsFilterOperatorType {
    EQUAL("Equal"),
    NOT_EQUAL("NotEqual"),
    BEGIN_WITH("BeginWith"),
    LESS_THAN("LessThan"),
    GREATER_THAN("GreaterThan"),
    EXISTS("Exists"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsFilterOperatorType> VALUE_MAP;
    private final String value;

    private OpsFilterOperatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpsFilterOperatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpsFilterOperatorType> knownValues() {
        EnumSet<OpsFilterOperatorType> knownValues = EnumSet.allOf(OpsFilterOperatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpsFilterOperatorType.class, OpsFilterOperatorType::toString);
    }
}

