/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter for the DescribeActivation API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActivationsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeActivationsFilter.Builder, DescribeActivationsFilter> {
    private static final SdkField<String> FILTER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterKey").getter(getter(DescribeActivationsFilter::filterKeyAsString))
            .setter(setter(Builder::filterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterKey").build()).build();

    private static final SdkField<List<String>> FILTER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterValues")
            .getter(getter(DescribeActivationsFilter::filterValues))
            .setter(setter(Builder::filterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_KEY_FIELD,
            FILTER_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterKey;

    private final List<String> filterValues;

    private DescribeActivationsFilter(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterKey} will
     * return {@link DescribeActivationsFilterKeys#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterKeyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see DescribeActivationsFilterKeys
     */
    public final DescribeActivationsFilterKeys filterKey() {
        return DescribeActivationsFilterKeys.fromValue(filterKey);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterKey} will
     * return {@link DescribeActivationsFilterKeys#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterKeyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see DescribeActivationsFilterKeys
     */
    public final String filterKeyAsString() {
        return filterKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterValues() {
        return filterValues != null && !(filterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterValues} method.
     * </p>
     * 
     * @return The filter values.
     */
    public final List<String> filterValues() {
        return filterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterValues() ? filterValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsFilter)) {
            return false;
        }
        DescribeActivationsFilter other = (DescribeActivationsFilter) obj;
        return Objects.equals(filterKeyAsString(), other.filterKeyAsString()) && hasFilterValues() == other.hasFilterValues()
                && Objects.equals(filterValues(), other.filterValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActivationsFilter").add("FilterKey", filterKeyAsString())
                .add("FilterValues", hasFilterValues() ? filterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterKey":
            return Optional.ofNullable(clazz.cast(filterKeyAsString()));
        case "FilterValues":
            return Optional.ofNullable(clazz.cast(filterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivationsFilter, T> g) {
        return obj -> g.apply((DescribeActivationsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeActivationsFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterKey
         *        The name of the filter.
         * @see DescribeActivationsFilterKeys
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeActivationsFilterKeys
         */
        Builder filterKey(String filterKey);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterKey
         *        The name of the filter.
         * @see DescribeActivationsFilterKeys
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeActivationsFilterKeys
         */
        Builder filterKey(DescribeActivationsFilterKeys filterKey);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param filterValues
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(Collection<String> filterValues);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param filterValues
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(String... filterValues);
    }

    static final class BuilderImpl implements Builder {
        private String filterKey;

        private List<String> filterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsFilter model) {
            filterKey(model.filterKey);
            filterValues(model.filterValues);
        }

        public final String getFilterKey() {
            return filterKey;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        @Override
        public final Builder filterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey == null ? null : filterKey.toString());
            return this;
        }

        public final Collection<String> getFilterValues() {
            if (filterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return filterValues;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String... filterValues) {
            filterValues(Arrays.asList(filterValues));
            return this;
        }

        @Override
        public DescribeActivationsFilter build() {
            return new DescribeActivationsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
