/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReviewStatus {
    APPROVED("APPROVED"),
    NOT_REVIEWED("NOT_REVIEWED"),
    PENDING("PENDING"),
    REJECTED("REJECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReviewStatus> VALUE_MAP;
    private final String value;

    private ReviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReviewStatus> knownValues() {
        EnumSet<ReviewStatus> knownValues = EnumSet.allOf(ReviewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReviewStatus.class, ReviewStatus::toString);
    }
}

