/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemNotification;
import software.amazon.awssdk.services.ssm.model.OpsItemNotificationsCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItem;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItemsCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOpsItemRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateOpsItemRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::description)).setter(CreateOpsItemRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> OPS_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemType").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::opsItemType)).setter(CreateOpsItemRequest.setter(Builder::opsItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemType").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::operationalData)).setter(CreateOpsItemRequest.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OpsItemNotification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notifications").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::notifications)).setter(CreateOpsItemRequest.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::priority)).setter(CreateOpsItemRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<List<RelatedOpsItem>> RELATED_OPS_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedOpsItems").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::relatedOpsItems)).setter(CreateOpsItemRequest.setter(Builder::relatedOpsItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpsItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedOpsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::source)).setter(CreateOpsItemRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::title)).setter(CreateOpsItemRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::tags)).setter(CreateOpsItemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::category)).setter(CreateOpsItemRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::severity)).setter(CreateOpsItemRequest.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Instant> ACTUAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualStartTime").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::actualStartTime)).setter(CreateOpsItemRequest.setter(Builder::actualStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualStartTime").build()}).build();
    private static final SdkField<Instant> ACTUAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualEndTime").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::actualEndTime)).setter(CreateOpsItemRequest.setter(Builder::actualEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEndTime").build()}).build();
    private static final SdkField<Instant> PLANNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedStartTime").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::plannedStartTime)).setter(CreateOpsItemRequest.setter(Builder::plannedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedStartTime").build()}).build();
    private static final SdkField<Instant> PLANNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedEndTime").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::plannedEndTime)).setter(CreateOpsItemRequest.setter(Builder::plannedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, OPS_ITEM_TYPE_FIELD, OPERATIONAL_DATA_FIELD, NOTIFICATIONS_FIELD, PRIORITY_FIELD, RELATED_OPS_ITEMS_FIELD, SOURCE_FIELD, TITLE_FIELD, TAGS_FIELD, CATEGORY_FIELD, SEVERITY_FIELD, ACTUAL_START_TIME_FIELD, ACTUAL_END_TIME_FIELD, PLANNED_START_TIME_FIELD, PLANNED_END_TIME_FIELD));
    private final String description;
    private final String opsItemType;
    private final Map<String, OpsItemDataValue> operationalData;
    private final List<OpsItemNotification> notifications;
    private final Integer priority;
    private final List<RelatedOpsItem> relatedOpsItems;
    private final String source;
    private final String title;
    private final List<Tag> tags;
    private final String category;
    private final String severity;
    private final Instant actualStartTime;
    private final Instant actualEndTime;
    private final Instant plannedStartTime;
    private final Instant plannedEndTime;

    private CreateOpsItemRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.opsItemType = builder.opsItemType;
        this.operationalData = builder.operationalData;
        this.notifications = builder.notifications;
        this.priority = builder.priority;
        this.relatedOpsItems = builder.relatedOpsItems;
        this.source = builder.source;
        this.title = builder.title;
        this.tags = builder.tags;
        this.category = builder.category;
        this.severity = builder.severity;
        this.actualStartTime = builder.actualStartTime;
        this.actualEndTime = builder.actualEndTime;
        this.plannedStartTime = builder.plannedStartTime;
        this.plannedEndTime = builder.plannedEndTime;
    }

    public final String description() {
        return this.description;
    }

    public final String opsItemType() {
        return this.opsItemType;
    }

    public final boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public final Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<OpsItemNotification> notifications() {
        return this.notifications;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasRelatedOpsItems() {
        return this.relatedOpsItems != null && !(this.relatedOpsItems instanceof SdkAutoConstructList);
    }

    public final List<RelatedOpsItem> relatedOpsItems() {
        return this.relatedOpsItems;
    }

    public final String source() {
        return this.source;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String category() {
        return this.category;
    }

    public final String severity() {
        return this.severity;
    }

    public final Instant actualStartTime() {
        return this.actualStartTime;
    }

    public final Instant actualEndTime() {
        return this.actualEndTime;
    }

    public final Instant plannedStartTime() {
        return this.plannedStartTime;
    }

    public final Instant plannedEndTime() {
        return this.plannedEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedOpsItems() ? this.relatedOpsItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpsItemRequest)) {
            return false;
        }
        CreateOpsItemRequest other = (CreateOpsItemRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.opsItemType(), other.opsItemType()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.priority(), other.priority()) && this.hasRelatedOpsItems() == other.hasRelatedOpsItems() && Objects.equals(this.relatedOpsItems(), other.relatedOpsItems()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.title(), other.title()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.actualStartTime(), other.actualStartTime()) && Objects.equals(this.actualEndTime(), other.actualEndTime()) && Objects.equals(this.plannedStartTime(), other.plannedStartTime()) && Objects.equals(this.plannedEndTime(), other.plannedEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOpsItemRequest").add("Description", (Object)this.description()).add("OpsItemType", (Object)this.opsItemType()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("Notifications", this.hasNotifications() ? this.notifications() : null).add("Priority", (Object)this.priority()).add("RelatedOpsItems", this.hasRelatedOpsItems() ? this.relatedOpsItems() : null).add("Source", (Object)this.source()).add("Title", (Object)this.title()).add("Tags", this.hasTags() ? this.tags() : null).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).add("ActualStartTime", (Object)this.actualStartTime()).add("ActualEndTime", (Object)this.actualEndTime()).add("PlannedStartTime", (Object)this.plannedStartTime()).add("PlannedEndTime", (Object)this.plannedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OpsItemType": {
                return Optional.ofNullable(clazz.cast(this.opsItemType()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RelatedOpsItems": {
                return Optional.ofNullable(clazz.cast(this.relatedOpsItems()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "ActualStartTime": {
                return Optional.ofNullable(clazz.cast(this.actualStartTime()));
            }
            case "ActualEndTime": {
                return Optional.ofNullable(clazz.cast(this.actualEndTime()));
            }
            case "PlannedStartTime": {
                return Optional.ofNullable(clazz.cast(this.plannedStartTime()));
            }
            case "PlannedEndTime": {
                return Optional.ofNullable(clazz.cast(this.plannedEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpsItemRequest, T> g) {
        return obj -> g.apply((CreateOpsItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String description;
        private String opsItemType;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private List<OpsItemNotification> notifications = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private List<RelatedOpsItem> relatedOpsItems = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private String title;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String category;
        private String severity;
        private Instant actualStartTime;
        private Instant actualEndTime;
        private Instant plannedStartTime;
        private Instant plannedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpsItemRequest model) {
            super(model);
            this.description(model.description);
            this.opsItemType(model.opsItemType);
            this.operationalData(model.operationalData);
            this.notifications(model.notifications);
            this.priority(model.priority);
            this.relatedOpsItems(model.relatedOpsItems);
            this.source(model.source);
            this.title(model.title);
            this.tags(model.tags);
            this.category(model.category);
            this.severity(model.severity);
            this.actualStartTime(model.actualStartTime);
            this.actualEndTime(model.actualEndTime);
            this.plannedStartTime(model.plannedStartTime);
            this.plannedEndTime(model.plannedEndTime);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOpsItemType() {
            return this.opsItemType;
        }

        public final void setOpsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
        }

        @Override
        @Transient
        public final Builder opsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
            return this;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            Map<String, OpsItemDataValue.Builder> result = OpsItemOperationalDataCopier.copyToBuilder(this.operationalData);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        @Override
        @Transient
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final List<OpsItemNotification.Builder> getNotifications() {
            List<OpsItemNotification.Builder> result = OpsItemNotificationsCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifications(Collection<OpsItemNotification.BuilderImpl> notifications) {
            this.notifications = OpsItemNotificationsCopier.copyFromBuilder(notifications);
        }

        @Override
        @Transient
        public final Builder notifications(Collection<OpsItemNotification> notifications) {
            this.notifications = OpsItemNotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notifications(OpsItemNotification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notifications(Consumer<OpsItemNotification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (OpsItemNotification)((OpsItemNotification.Builder)OpsItemNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<RelatedOpsItem.Builder> getRelatedOpsItems() {
            List<RelatedOpsItem.Builder> result = RelatedOpsItemsCopier.copyToBuilder(this.relatedOpsItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedOpsItems(Collection<RelatedOpsItem.BuilderImpl> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copyFromBuilder(relatedOpsItems);
        }

        @Override
        @Transient
        public final Builder relatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copy(relatedOpsItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
            this.relatedOpsItems(Arrays.asList(relatedOpsItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... relatedOpsItems) {
            this.relatedOpsItems(Stream.of(relatedOpsItems).map(c -> (RelatedOpsItem)((RelatedOpsItem.Builder)RelatedOpsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getActualStartTime() {
            return this.actualStartTime;
        }

        public final void setActualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
        }

        @Override
        @Transient
        public final Builder actualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
            return this;
        }

        public final Instant getActualEndTime() {
            return this.actualEndTime;
        }

        public final void setActualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
        }

        @Override
        @Transient
        public final Builder actualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
            return this;
        }

        public final Instant getPlannedStartTime() {
            return this.plannedStartTime;
        }

        public final void setPlannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
        }

        @Override
        @Transient
        public final Builder plannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
            return this;
        }

        public final Instant getPlannedEndTime() {
            return this.plannedEndTime;
        }

        public final void setPlannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
        }

        @Override
        @Transient
        public final Builder plannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOpsItemRequest build() {
            return new CreateOpsItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOpsItemRequest> {
        public Builder description(String var1);

        public Builder opsItemType(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder notifications(Collection<OpsItemNotification> var1);

        public Builder notifications(OpsItemNotification ... var1);

        public Builder notifications(Consumer<OpsItemNotification.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder relatedOpsItems(Collection<RelatedOpsItem> var1);

        public Builder relatedOpsItems(RelatedOpsItem ... var1);

        public Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... var1);

        public Builder source(String var1);

        public Builder title(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder category(String var1);

        public Builder severity(String var1);

        public Builder actualStartTime(Instant var1);

        public Builder actualEndTime(Instant var1);

        public Builder plannedStartTime(Instant var1);

        public Builder plannedEndTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

