/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTargetListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowTargetsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
    private static final SdkField<List<MaintenanceWindowTarget>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(DescribeMaintenanceWindowTargetsResponse.getter(DescribeMaintenanceWindowTargetsResponse::targets)).setter(DescribeMaintenanceWindowTargetsResponse.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowTargetsResponse.getter(DescribeMaintenanceWindowTargetsResponse::nextToken)).setter(DescribeMaintenanceWindowTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MaintenanceWindowTarget> targets;
    private final String nextToken;

    private DescribeMaintenanceWindowTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindowTarget> targets() {
        return this.targets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTargetsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTargetsResponse other = (DescribeMaintenanceWindowTargetsResponse)((Object)obj);
        return this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowTargetsResponse").add("Targets", this.hasTargets() ? this.targets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowTargetsResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTarget> targets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTargetsResponse model) {
            super(model);
            this.targets(model.targets);
            this.nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowTarget.Builder> getTargets() {
            List<MaintenanceWindowTarget.Builder> result = MaintenanceWindowTargetListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<MaintenanceWindowTarget.BuilderImpl> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(MaintenanceWindowTarget ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<MaintenanceWindowTarget.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (MaintenanceWindowTarget)((MaintenanceWindowTarget.Builder)MaintenanceWindowTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowTargetsResponse build() {
            return new DescribeMaintenanceWindowTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
        public Builder targets(Collection<MaintenanceWindowTarget> var1);

        public Builder targets(MaintenanceWindowTarget ... var1);

        public Builder targets(Consumer<MaintenanceWindowTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

