/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDocumentRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateDocumentRequest.Builder, UpdateDocumentRequest> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(UpdateDocumentRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<AttachmentsSource>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentsSource>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(UpdateDocumentRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentsSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentsSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDocumentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateDocumentRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(UpdateDocumentRequest::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(UpdateDocumentRequest::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentFormat").getter(getter(UpdateDocumentRequest::documentFormatAsString))
            .setter(setter(Builder::documentFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(UpdateDocumentRequest::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            ATTACHMENTS_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, VERSION_NAME_FIELD, DOCUMENT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD,
            TARGET_TYPE_FIELD));

    private final String content;

    private final List<AttachmentsSource> attachments;

    private final String name;

    private final String displayName;

    private final String versionName;

    private final String documentVersion;

    private final String documentFormat;

    private final String targetType;

    private UpdateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.attachments = builder.attachments;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.versionName = builder.versionName;
        this.documentVersion = builder.documentVersion;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * A valid JSON or YAML string.
     * </p>
     * 
     * @return A valid JSON or YAML string.
     */
    public final String content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that describe attachments to a version of a document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return A list of key-value pairs that describe attachments to a version of a document.
     */
    public final List<AttachmentsSource> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The name of the SSM document that you want to update.
     * </p>
     * 
     * @return The name of the SSM document that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The friendly name of the SSM document that you want to update. This value can differ for each version of the
     * document. If you don't specify a value for this parameter in your request, the existing value is applied to the
     * new document version.
     * </p>
     * 
     * @return The friendly name of the SSM document that you want to update. This value can differ for each version of
     *         the document. If you don't specify a value for this parameter in your request, the existing value is
     *         applied to the new document version.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact you are updating with the document. For example,
     * "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.
     * </p>
     * 
     * @return An optional field specifying the version of the artifact you are updating with the document. For example,
     *         "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The version of the document that you want to update. Currently, Systems Manager supports updating only the latest
     * version of the document. You can specify the version number of the latest version or use the <code>$LATEST</code>
     * variable.
     * </p>
     * 
     * @return The version of the document that you want to update. Currently, Systems Manager supports updating only
     *         the latest version of the document. You can specify the version number of the latest version or use the
     *         <code>$LATEST</code> variable.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON
     * is the default format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return Specify the document format for the new document version. Systems Manager supports JSON and YAML
     *         documents. JSON is the default format.
     * @see DocumentFormat
     */
    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(documentFormat);
    }

    /**
     * <p>
     * Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON
     * is the default format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return Specify the document format for the new document version. Systems Manager supports JSON and YAML
     *         documents. JSON is the default format.
     * @see DocumentFormat
     */
    public final String documentFormatAsString() {
        return documentFormat;
    }

    /**
     * <p>
     * Specify a new target type for the document.
     * </p>
     * 
     * @return Specify a new target type for the document.
     */
    public final String targetType() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest) obj;
        return Objects.equals(content(), other.content()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments()) && Objects.equals(name(), other.name())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(documentFormatAsString(), other.documentFormatAsString())
                && Objects.equals(targetType(), other.targetType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDocumentRequest").add("Content", content())
                .add("Attachments", hasAttachments() ? attachments() : null).add("Name", name())
                .add("DisplayName", displayName()).add("VersionName", versionName()).add("DocumentVersion", documentVersion())
                .add("DocumentFormat", documentFormatAsString()).add("TargetType", targetType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "DocumentFormat":
            return Optional.ofNullable(clazz.cast(documentFormatAsString()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDocumentRequest, T> g) {
        return obj -> g.apply((UpdateDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDocumentRequest> {
        /**
         * <p>
         * A valid JSON or YAML string.
         * </p>
         * 
         * @param content
         *        A valid JSON or YAML string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A list of key-value pairs that describe attachments to a version of a document.
         * </p>
         * 
         * @param attachments
         *        A list of key-value pairs that describe attachments to a version of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentsSource> attachments);

        /**
         * <p>
         * A list of key-value pairs that describe attachments to a version of a document.
         * </p>
         * 
         * @param attachments
         *        A list of key-value pairs that describe attachments to a version of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentsSource... attachments);

        /**
         * <p>
         * A list of key-value pairs that describe attachments to a version of a document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentsSource>.Builder} avoiding the
         * need to create one manually via {@link List<AttachmentsSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentsSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #attachments(List<AttachmentsSource>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AttachmentsSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AttachmentsSource>)
         */
        Builder attachments(Consumer<AttachmentsSource.Builder>... attachments);

        /**
         * <p>
         * The name of the SSM document that you want to update.
         * </p>
         * 
         * @param name
         *        The name of the SSM document that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The friendly name of the SSM document that you want to update. This value can differ for each version of the
         * document. If you don't specify a value for this parameter in your request, the existing value is applied to
         * the new document version.
         * </p>
         * 
         * @param displayName
         *        The friendly name of the SSM document that you want to update. This value can differ for each version
         *        of the document. If you don't specify a value for this parameter in your request, the existing value
         *        is applied to the new document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * An optional field specifying the version of the artifact you are updating with the document. For example,
         * "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.
         * </p>
         * 
         * @param versionName
         *        An optional field specifying the version of the artifact you are updating with the document. For
         *        example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be
         *        changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The version of the document that you want to update. Currently, Systems Manager supports updating only the
         * latest version of the document. You can specify the version number of the latest version or use the
         * <code>$LATEST</code> variable.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document that you want to update. Currently, Systems Manager supports updating only
         *        the latest version of the document. You can specify the version number of the latest version or use
         *        the <code>$LATEST</code> variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * Specify the document format for the new document version. Systems Manager supports JSON and YAML documents.
         * JSON is the default format.
         * </p>
         * 
         * @param documentFormat
         *        Specify the document format for the new document version. Systems Manager supports JSON and YAML
         *        documents. JSON is the default format.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(String documentFormat);

        /**
         * <p>
         * Specify the document format for the new document version. Systems Manager supports JSON and YAML documents.
         * JSON is the default format.
         * </p>
         * 
         * @param documentFormat
         *        Specify the document format for the new document version. Systems Manager supports JSON and YAML
         *        documents. JSON is the default format.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(DocumentFormat documentFormat);

        /**
         * <p>
         * Specify a new target type for the document.
         * </p>
         * 
         * @param targetType
         *        Specify a new target type for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String content;

        private List<AttachmentsSource> attachments = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String displayName;

        private String versionName;

        private String documentVersion;

        private String documentFormat;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            super(model);
            content(model.content);
            attachments(model.attachments);
            name(model.name);
            displayName(model.displayName);
            versionName(model.versionName);
            documentVersion(model.documentVersion);
            documentFormat(model.documentFormat);
            targetType(model.targetType);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final List<AttachmentsSource.Builder> getAttachments() {
            List<AttachmentsSource.Builder> result = AttachmentsSourceListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentsSource.BuilderImpl> attachments) {
            this.attachments = AttachmentsSourceListCopier.copyFromBuilder(attachments);
        }

        @Override
        @Transient
        public final Builder attachments(Collection<AttachmentsSource> attachments) {
            this.attachments = AttachmentsSourceListCopier.copy(attachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(AttachmentsSource... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentsSource.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentsSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getDocumentFormat() {
            return documentFormat;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        @Override
        @Transient
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        @Transient
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
