/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compliance summary information for a specific resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceComplianceSummaryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceComplianceSummaryItem.Builder, ResourceComplianceSummaryItem> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(ResourceComplianceSummaryItem::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceComplianceSummaryItem::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceComplianceSummaryItem::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResourceComplianceSummaryItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> OVERALL_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverallSeverity").getter(getter(ResourceComplianceSummaryItem::overallSeverityAsString))
            .setter(setter(Builder::overallSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallSeverity").build()).build();

    private static final SdkField<ComplianceExecutionSummary> EXECUTION_SUMMARY_FIELD = SdkField
            .<ComplianceExecutionSummary> builder(MarshallingType.SDK_POJO).memberName("ExecutionSummary")
            .getter(getter(ResourceComplianceSummaryItem::executionSummary)).setter(setter(Builder::executionSummary))
            .constructor(ComplianceExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()).build();

    private static final SdkField<CompliantSummary> COMPLIANT_SUMMARY_FIELD = SdkField
            .<CompliantSummary> builder(MarshallingType.SDK_POJO).memberName("CompliantSummary")
            .getter(getter(ResourceComplianceSummaryItem::compliantSummary)).setter(setter(Builder::compliantSummary))
            .constructor(CompliantSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantSummary").build()).build();

    private static final SdkField<NonCompliantSummary> NON_COMPLIANT_SUMMARY_FIELD = SdkField
            .<NonCompliantSummary> builder(MarshallingType.SDK_POJO).memberName("NonCompliantSummary")
            .getter(getter(ResourceComplianceSummaryItem::nonCompliantSummary)).setter(setter(Builder::nonCompliantSummary))
            .constructor(NonCompliantSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, OVERALL_SEVERITY_FIELD, EXECUTION_SUMMARY_FIELD,
            COMPLIANT_SUMMARY_FIELD, NON_COMPLIANT_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String complianceType;

    private final String resourceType;

    private final String resourceId;

    private final String status;

    private final String overallSeverity;

    private final ComplianceExecutionSummary executionSummary;

    private final CompliantSummary compliantSummary;

    private final NonCompliantSummary nonCompliantSummary;

    private ResourceComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.overallSeverity = builder.overallSeverity;
        this.executionSummary = builder.executionSummary;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    /**
     * <p>
     * The compliance type.
     * </p>
     * 
     * @return The compliance type.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The resource ID.
     * </p>
     * 
     * @return The resource ID.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The compliance status for the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The compliance status for the resource.
     * @see ComplianceStatus
     */
    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(status);
    }

    /**
     * <p>
     * The compliance status for the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The compliance status for the resource.
     * @see ComplianceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The highest severity item found for the resource. The resource is compliant for this item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overallSeverity}
     * will return {@link ComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overallSeverityAsString}.
     * </p>
     * 
     * @return The highest severity item found for the resource. The resource is compliant for this item.
     * @see ComplianceSeverity
     */
    public final ComplianceSeverity overallSeverity() {
        return ComplianceSeverity.fromValue(overallSeverity);
    }

    /**
     * <p>
     * The highest severity item found for the resource. The resource is compliant for this item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overallSeverity}
     * will return {@link ComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overallSeverityAsString}.
     * </p>
     * 
     * @return The highest severity item found for the resource. The resource is compliant for this item.
     * @see ComplianceSeverity
     */
    public final String overallSeverityAsString() {
        return overallSeverity;
    }

    /**
     * <p>
     * Information about the execution.
     * </p>
     * 
     * @return Information about the execution.
     */
    public final ComplianceExecutionSummary executionSummary() {
        return executionSummary;
    }

    /**
     * <p>
     * A list of items that are compliant for the resource.
     * </p>
     * 
     * @return A list of items that are compliant for the resource.
     */
    public final CompliantSummary compliantSummary() {
        return compliantSummary;
    }

    /**
     * <p>
     * A list of items that aren't compliant for the resource.
     * </p>
     * 
     * @return A list of items that aren't compliant for the resource.
     */
    public final NonCompliantSummary nonCompliantSummary() {
        return nonCompliantSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overallSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceComplianceSummaryItem)) {
            return false;
        }
        ResourceComplianceSummaryItem other = (ResourceComplianceSummaryItem) obj;
        return Objects.equals(complianceType(), other.complianceType()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(overallSeverityAsString(), other.overallSeverityAsString())
                && Objects.equals(executionSummary(), other.executionSummary())
                && Objects.equals(compliantSummary(), other.compliantSummary())
                && Objects.equals(nonCompliantSummary(), other.nonCompliantSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceComplianceSummaryItem").add("ComplianceType", complianceType())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId()).add("Status", statusAsString())
                .add("OverallSeverity", overallSeverityAsString()).add("ExecutionSummary", executionSummary())
                .add("CompliantSummary", compliantSummary()).add("NonCompliantSummary", nonCompliantSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OverallSeverity":
            return Optional.ofNullable(clazz.cast(overallSeverityAsString()));
        case "ExecutionSummary":
            return Optional.ofNullable(clazz.cast(executionSummary()));
        case "CompliantSummary":
            return Optional.ofNullable(clazz.cast(compliantSummary()));
        case "NonCompliantSummary":
            return Optional.ofNullable(clazz.cast(nonCompliantSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceComplianceSummaryItem, T> g) {
        return obj -> g.apply((ResourceComplianceSummaryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceComplianceSummaryItem> {
        /**
         * <p>
         * The compliance type.
         * </p>
         * 
         * @param complianceType
         *        The compliance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource ID.
         * </p>
         * 
         * @param resourceId
         *        The resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The compliance status for the resource.
         * </p>
         * 
         * @param status
         *        The compliance status for the resource.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The compliance status for the resource.
         * </p>
         * 
         * @param status
         *        The compliance status for the resource.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(ComplianceStatus status);

        /**
         * <p>
         * The highest severity item found for the resource. The resource is compliant for this item.
         * </p>
         * 
         * @param overallSeverity
         *        The highest severity item found for the resource. The resource is compliant for this item.
         * @see ComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceSeverity
         */
        Builder overallSeverity(String overallSeverity);

        /**
         * <p>
         * The highest severity item found for the resource. The resource is compliant for this item.
         * </p>
         * 
         * @param overallSeverity
         *        The highest severity item found for the resource. The resource is compliant for this item.
         * @see ComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceSeverity
         */
        Builder overallSeverity(ComplianceSeverity overallSeverity);

        /**
         * <p>
         * Information about the execution.
         * </p>
         * 
         * @param executionSummary
         *        Information about the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummary(ComplianceExecutionSummary executionSummary);

        /**
         * <p>
         * Information about the execution.
         * </p>
         * This is a convenience that creates an instance of the {@link ComplianceExecutionSummary.Builder} avoiding the
         * need to create one manually via {@link ComplianceExecutionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComplianceExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #executionSummary(ComplianceExecutionSummary)}.
         * 
         * @param executionSummary
         *        a consumer that will call methods on {@link ComplianceExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSummary(ComplianceExecutionSummary)
         */
        default Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return executionSummary(ComplianceExecutionSummary.builder().applyMutation(executionSummary).build());
        }

        /**
         * <p>
         * A list of items that are compliant for the resource.
         * </p>
         * 
         * @param compliantSummary
         *        A list of items that are compliant for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantSummary(CompliantSummary compliantSummary);

        /**
         * <p>
         * A list of items that are compliant for the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link CompliantSummary.Builder} avoiding the need to
         * create one manually via {@link CompliantSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CompliantSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #compliantSummary(CompliantSummary)}.
         * 
         * @param compliantSummary
         *        a consumer that will call methods on {@link CompliantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliantSummary(CompliantSummary)
         */
        default Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return compliantSummary(CompliantSummary.builder().applyMutation(compliantSummary).build());
        }

        /**
         * <p>
         * A list of items that aren't compliant for the resource.
         * </p>
         * 
         * @param nonCompliantSummary
         *        A list of items that aren't compliant for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary);

        /**
         * <p>
         * A list of items that aren't compliant for the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link NonCompliantSummary.Builder} avoiding the need
         * to create one manually via {@link NonCompliantSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link NonCompliantSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #nonCompliantSummary(NonCompliantSummary)}.
         * 
         * @param nonCompliantSummary
         *        a consumer that will call methods on {@link NonCompliantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nonCompliantSummary(NonCompliantSummary)
         */
        default Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return nonCompliantSummary(NonCompliantSummary.builder().applyMutation(nonCompliantSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String complianceType;

        private String resourceType;

        private String resourceId;

        private String status;

        private String overallSeverity;

        private ComplianceExecutionSummary executionSummary;

        private CompliantSummary compliantSummary;

        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceComplianceSummaryItem model) {
            complianceType(model.complianceType);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            status(model.status);
            overallSeverity(model.overallSeverity);
            executionSummary(model.executionSummary);
            compliantSummary(model.compliantSummary);
            nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOverallSeverity() {
            return overallSeverity;
        }

        public final void setOverallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
        }

        @Override
        @Transient
        public final Builder overallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
            return this;
        }

        @Override
        @Transient
        public final Builder overallSeverity(ComplianceSeverity overallSeverity) {
            this.overallSeverity(overallSeverity == null ? null : overallSeverity.toString());
            return this;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return executionSummary != null ? executionSummary.toBuilder() : null;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return compliantSummary != null ? compliantSummary.toBuilder() : null;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return nonCompliantSummary != null ? nonCompliantSummary.toBuilder() : null;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        @Override
        public ResourceComplianceSummaryItem build() {
            return new ResourceComplianceSummaryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
