/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperatingSystem {
    WINDOWS("WINDOWS"),
    AMAZON_LINUX("AMAZON_LINUX"),
    AMAZON_LINUX_2("AMAZON_LINUX_2"),
    UBUNTU("UBUNTU"),
    REDHAT_ENTERPRISE_LINUX("REDHAT_ENTERPRISE_LINUX"),
    SUSE("SUSE"),
    CENTOS("CENTOS"),
    ORACLE_LINUX("ORACLE_LINUX"),
    DEBIAN("DEBIAN"),
    MACOS("MACOS"),
    RASPBIAN("RASPBIAN"),
    ROCKY_LINUX("ROCKY_LINUX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperatingSystem> VALUE_MAP;
    private final String value;

    private OperatingSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatingSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatingSystem> knownValues() {
        EnumSet<OperatingSystem> knownValues = EnumSet.allOf(OperatingSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperatingSystem.class, OperatingSystem::toString);
    }
}

