/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowLambdaParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientContext").getter(MaintenanceWindowLambdaParameters.getter(MaintenanceWindowLambdaParameters::clientContext)).setter(MaintenanceWindowLambdaParameters.setter(Builder::clientContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientContext").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(MaintenanceWindowLambdaParameters.getter(MaintenanceWindowLambdaParameters::qualifier)).setter(MaintenanceWindowLambdaParameters.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualifier").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Payload").getter(MaintenanceWindowLambdaParameters.getter(MaintenanceWindowLambdaParameters::payload)).setter(MaintenanceWindowLambdaParameters.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONTEXT_FIELD, QUALIFIER_FIELD, PAYLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientContext;
    private final String qualifier;
    private final SdkBytes payload;

    private MaintenanceWindowLambdaParameters(BuilderImpl builder) {
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    public final String clientContext() {
        return this.clientContext;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowLambdaParameters)) {
            return false;
        }
        MaintenanceWindowLambdaParameters other = (MaintenanceWindowLambdaParameters)obj;
        return Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowLambdaParameters").add("ClientContext", (Object)this.clientContext()).add("Qualifier", (Object)this.qualifier()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowLambdaParameters, T> g) {
        return obj -> g.apply((MaintenanceWindowLambdaParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientContext;
        private String qualifier;
        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowLambdaParameters model) {
            this.clientContext(model.clientContext);
            this.qualifier(model.qualifier);
            this.payload(model.payload);
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public MaintenanceWindowLambdaParameters build() {
            return new MaintenanceWindowLambdaParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
        public Builder clientContext(String var1);

        public Builder qualifier(String var1);

        public Builder payload(SdkBytes var1);
    }
}

