/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;

public class ListComplianceSummariesPublisher
implements SdkPublisher<ListComplianceSummariesResponse> {
    private final SsmAsyncClient client;
    private final ListComplianceSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComplianceSummariesPublisher(SsmAsyncClient client, ListComplianceSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComplianceSummariesPublisher(SsmAsyncClient client, ListComplianceSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComplianceSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComplianceSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComplianceSummaryItem> complianceSummaryItems() {
        Function<ListComplianceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceSummaryItems() != null) {
                return response.complianceSummaryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComplianceSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComplianceSummariesResponseFetcher
    implements AsyncPageFetcher<ListComplianceSummariesResponse> {
        private ListComplianceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComplianceSummariesResponse> nextPage(ListComplianceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceSummariesPublisher.this.client.listComplianceSummaries(ListComplianceSummariesPublisher.this.firstRequest);
            }
            return ListComplianceSummariesPublisher.this.client.listComplianceSummaries((ListComplianceSummariesRequest)((Object)ListComplianceSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

