/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.Session;

public class DescribeSessionsIterable
implements SdkIterable<DescribeSessionsResponse> {
    private final SsmClient client;
    private final DescribeSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSessionsIterable(SsmClient client, DescribeSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSessionsResponseFetcher();
    }

    public Iterator<DescribeSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Session> sessions() {
        Function<DescribeSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSessionsResponseFetcher
    implements SyncPageFetcher<DescribeSessionsResponse> {
        private DescribeSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSessionsResponse nextPage(DescribeSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSessionsIterable.this.client.describeSessions(DescribeSessionsIterable.this.firstRequest);
            }
            return DescribeSessionsIterable.this.client.describeSessions((DescribeSessionsRequest)((Object)DescribeSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

