/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentMetadataHistoryResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListDocumentMetadataHistoryResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ListDocumentMetadataHistoryResponse.getter(ListDocumentMetadataHistoryResponse::name)).setter(ListDocumentMetadataHistoryResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(ListDocumentMetadataHistoryResponse.getter(ListDocumentMetadataHistoryResponse::documentVersion)).setter(ListDocumentMetadataHistoryResponse.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(ListDocumentMetadataHistoryResponse.getter(ListDocumentMetadataHistoryResponse::author)).setter(ListDocumentMetadataHistoryResponse.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Author").build()}).build();
    private static final SdkField<DocumentMetadataResponseInfo> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(ListDocumentMetadataHistoryResponse.getter(ListDocumentMetadataHistoryResponse::metadata)).setter(ListDocumentMetadataHistoryResponse.setter(Builder::metadata)).constructor(DocumentMetadataResponseInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentMetadataHistoryResponse.getter(ListDocumentMetadataHistoryResponse::nextToken)).setter(ListDocumentMetadataHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTHOR_FIELD, METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final String name;
    private final String documentVersion;
    private final String author;
    private final DocumentMetadataResponseInfo metadata;
    private final String nextToken;

    private ListDocumentMetadataHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.author = builder.author;
        this.metadata = builder.metadata;
        this.nextToken = builder.nextToken;
    }

    public final String name() {
        return this.name;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String author() {
        return this.author;
    }

    public final DocumentMetadataResponseInfo metadata() {
        return this.metadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentMetadataHistoryResponse)) {
            return false;
        }
        ListDocumentMetadataHistoryResponse other = (ListDocumentMetadataHistoryResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentMetadataHistoryResponse").add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("Author", (Object)this.author()).add("Metadata", (Object)this.metadata()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentMetadataHistoryResponse, T> g) {
        return obj -> g.apply((ListDocumentMetadataHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String name;
        private String documentVersion;
        private String author;
        private DocumentMetadataResponseInfo metadata;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentMetadataHistoryResponse model) {
            super(model);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.author(model.author);
            this.metadata(model.metadata);
            this.nextToken(model.nextToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        @Transient
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final DocumentMetadataResponseInfo.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentMetadataResponseInfo.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(DocumentMetadataResponseInfo metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentMetadataHistoryResponse build() {
            return new ListDocumentMetadataHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentMetadataHistoryResponse> {
        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder author(String var1);

        public Builder metadata(DocumentMetadataResponseInfo var1);

        default public Builder metadata(Consumer<DocumentMetadataResponseInfo.Builder> metadata) {
            return this.metadata((DocumentMetadataResponseInfo)((DocumentMetadataResponseInfo.Builder)DocumentMetadataResponseInfo.builder().applyMutation(metadata)).build());
        }

        public Builder nextToken(String var1);
    }
}

