/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskCutoffBehavior;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTaskWithMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::windowId)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::targets)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::taskArn)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::serviceRoleArn)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskType").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::taskTypeAsString)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()}).build();
    private static final SdkField<Map<String, MaintenanceWindowTaskParameterValueExpression>> TASK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TaskParameters").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::taskParameters)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::taskParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowTaskParameterValueExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MaintenanceWindowTaskInvocationParameters> TASK_INVOCATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskInvocationParameters").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::taskInvocationParameters)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::taskInvocationParameters)).constructor(MaintenanceWindowTaskInvocationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInvocationParameters").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::priority)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::maxConcurrency)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::maxErrors)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::loggingInfo)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingInfo").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::name)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::description)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::clientToken)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CUTOFF_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CutoffBehavior").getter(RegisterTaskWithMaintenanceWindowRequest.getter(RegisterTaskWithMaintenanceWindowRequest::cutoffBehaviorAsString)).setter(RegisterTaskWithMaintenanceWindowRequest.setter(Builder::cutoffBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CutoffBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, TARGETS_FIELD, TASK_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, TASK_TYPE_FIELD, TASK_PARAMETERS_FIELD, TASK_INVOCATION_PARAMETERS_FIELD, PRIORITY_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, LOGGING_INFO_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, CUTOFF_BEHAVIOR_FIELD));
    private final String windowId;
    private final List<Target> targets;
    private final String taskArn;
    private final String serviceRoleArn;
    private final String taskType;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final LoggingInfo loggingInfo;
    private final String name;
    private final String description;
    private final String clientToken;
    private final String cutoffBehavior;

    private RegisterTaskWithMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskType = builder.taskType;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.cutoffBehavior = builder.cutoffBehavior;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public final boolean hasTaskParameters() {
        return this.taskParameters != null && !(this.taskParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public final MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return this.taskInvocationParameters;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final MaintenanceWindowTaskCutoffBehavior cutoffBehavior() {
        return MaintenanceWindowTaskCutoffBehavior.fromValue(this.cutoffBehavior);
    }

    public final String cutoffBehaviorAsString() {
        return this.cutoffBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskParameters() ? this.taskParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoffBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowRequest other = (RegisterTaskWithMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && this.hasTaskParameters() == other.hasTaskParameters() && Objects.equals(this.taskParameters(), other.taskParameters()) && Objects.equals(this.taskInvocationParameters(), other.taskInvocationParameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.cutoffBehaviorAsString(), other.cutoffBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTaskWithMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("Targets", this.hasTargets() ? this.targets() : null).add("TaskArn", (Object)this.taskArn()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TaskType", (Object)this.taskTypeAsString()).add("TaskParameters", (Object)(this.taskParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("TaskInvocationParameters", (Object)this.taskInvocationParameters()).add("Priority", (Object)this.priority()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("LoggingInfo", (Object)this.loggingInfo()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("CutoffBehavior", (Object)this.cutoffBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "TaskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "TaskParameters": {
                return Optional.ofNullable(clazz.cast(this.taskParameters()));
            }
            case "TaskInvocationParameters": {
                return Optional.ofNullable(clazz.cast(this.taskInvocationParameters()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CutoffBehavior": {
                return Optional.ofNullable(clazz.cast(this.cutoffBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTaskWithMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((RegisterTaskWithMaintenanceWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String taskArn;
        private String serviceRoleArn;
        private String taskType;
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters = DefaultSdkAutoConstructMap.getInstance();
        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private LoggingInfo loggingInfo;
        private String name;
        private String description;
        private String clientToken;
        private String cutoffBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskWithMaintenanceWindowRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.targets(model.targets);
            this.taskArn(model.taskArn);
            this.serviceRoleArn(model.serviceRoleArn);
            this.taskType(model.taskType);
            this.taskParameters(model.taskParameters);
            this.taskInvocationParameters(model.taskInvocationParameters);
            this.priority(model.priority);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.loggingInfo(model.loggingInfo);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.cutoffBehavior(model.cutoffBehavior);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        @Transient
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        @Transient
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        @Transient
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        @Transient
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> result = MaintenanceWindowTaskParametersCopier.copyToBuilder(this.taskParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        @Override
        @Transient
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return this.taskInvocationParameters != null ? this.taskInvocationParameters.toBuilder() : null;
        }

        public final void setTaskInvocationParameters(MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        @Transient
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        @Transient
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCutoffBehavior() {
            return this.cutoffBehavior;
        }

        public final void setCutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
        }

        @Override
        @Transient
        public final Builder cutoffBehavior(String cutoffBehavior) {
            this.cutoffBehavior = cutoffBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior cutoffBehavior) {
            this.cutoffBehavior(cutoffBehavior == null ? null : cutoffBehavior.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTaskWithMaintenanceWindowRequest build() {
            return new RegisterTaskWithMaintenanceWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder taskArn(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters var1);

        default public Builder taskInvocationParameters(Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return this.taskInvocationParameters((MaintenanceWindowTaskInvocationParameters)((MaintenanceWindowTaskInvocationParameters.Builder)MaintenanceWindowTaskInvocationParameters.builder().applyMutation(taskInvocationParameters)).build());
        }

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder cutoffBehavior(String var1);

        public Builder cutoffBehavior(MaintenanceWindowTaskCutoffBehavior var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

