/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem;
import software.amazon.awssdk.services.ssm.model.RegistrationMetadataListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActivationRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateActivationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateActivationRequest.getter(CreateActivationRequest::description)).setter(CreateActivationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultInstanceName").getter(CreateActivationRequest.getter(CreateActivationRequest::defaultInstanceName)).setter(CreateActivationRequest.setter(Builder::defaultInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceName").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRole").getter(CreateActivationRequest.getter(CreateActivationRequest::iamRole)).setter(CreateActivationRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<Integer> REGISTRATION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegistrationLimit").getter(CreateActivationRequest.getter(CreateActivationRequest::registrationLimit)).setter(CreateActivationRequest.setter(Builder::registrationLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationLimit").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(CreateActivationRequest.getter(CreateActivationRequest::expirationDate)).setter(CreateActivationRequest.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateActivationRequest.getter(CreateActivationRequest::tags)).setter(CreateActivationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RegistrationMetadataItem>> REGISTRATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegistrationMetadata").getter(CreateActivationRequest.getter(CreateActivationRequest::registrationMetadata)).setter(CreateActivationRequest.setter(Builder::registrationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrationMetadataItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DEFAULT_INSTANCE_NAME_FIELD, IAM_ROLE_FIELD, REGISTRATION_LIMIT_FIELD, EXPIRATION_DATE_FIELD, TAGS_FIELD, REGISTRATION_METADATA_FIELD));
    private final String description;
    private final String defaultInstanceName;
    private final String iamRole;
    private final Integer registrationLimit;
    private final Instant expirationDate;
    private final List<Tag> tags;
    private final List<RegistrationMetadataItem> registrationMetadata;

    private CreateActivationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.expirationDate = builder.expirationDate;
        this.tags = builder.tags;
        this.registrationMetadata = builder.registrationMetadata;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultInstanceName() {
        return this.defaultInstanceName;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final Integer registrationLimit() {
        return this.registrationLimit;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasRegistrationMetadata() {
        return this.registrationMetadata != null && !(this.registrationMetadata instanceof SdkAutoConstructList);
    }

    public final List<RegistrationMetadataItem> registrationMetadata() {
        return this.registrationMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistrationMetadata() ? this.registrationMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationRequest)) {
            return false;
        }
        CreateActivationRequest other = (CreateActivationRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultInstanceName(), other.defaultInstanceName()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationLimit(), other.registrationLimit()) && Objects.equals(this.expirationDate(), other.expirationDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasRegistrationMetadata() == other.hasRegistrationMetadata() && Objects.equals(this.registrationMetadata(), other.registrationMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"CreateActivationRequest").add("Description", (Object)this.description()).add("DefaultInstanceName", (Object)this.defaultInstanceName()).add("IamRole", (Object)this.iamRole()).add("RegistrationLimit", (Object)this.registrationLimit()).add("ExpirationDate", (Object)this.expirationDate()).add("Tags", this.hasTags() ? this.tags() : null).add("RegistrationMetadata", this.hasRegistrationMetadata() ? this.registrationMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultInstanceName": {
                return Optional.ofNullable(clazz.cast(this.defaultInstanceName()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "RegistrationLimit": {
                return Optional.ofNullable(clazz.cast(this.registrationLimit()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RegistrationMetadata": {
                return Optional.ofNullable(clazz.cast(this.registrationMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivationRequest, T> g) {
        return obj -> g.apply((CreateActivationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String description;
        private String defaultInstanceName;
        private String iamRole;
        private Integer registrationLimit;
        private Instant expirationDate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<RegistrationMetadataItem> registrationMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationRequest model) {
            super(model);
            this.description(model.description);
            this.defaultInstanceName(model.defaultInstanceName);
            this.iamRole(model.iamRole);
            this.registrationLimit(model.registrationLimit);
            this.expirationDate(model.expirationDate);
            this.tags(model.tags);
            this.registrationMetadata(model.registrationMetadata);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultInstanceName() {
            return this.defaultInstanceName;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        @Override
        @Transient
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        @Transient
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Integer getRegistrationLimit() {
            return this.registrationLimit;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        @Override
        @Transient
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        @Transient
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RegistrationMetadataItem.Builder> getRegistrationMetadata() {
            List<RegistrationMetadataItem.Builder> result = RegistrationMetadataListCopier.copyToBuilder(this.registrationMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationMetadata(Collection<RegistrationMetadataItem.BuilderImpl> registrationMetadata) {
            this.registrationMetadata = RegistrationMetadataListCopier.copyFromBuilder(registrationMetadata);
        }

        @Override
        @Transient
        public final Builder registrationMetadata(Collection<RegistrationMetadataItem> registrationMetadata) {
            this.registrationMetadata = RegistrationMetadataListCopier.copy(registrationMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder registrationMetadata(RegistrationMetadataItem ... registrationMetadata) {
            this.registrationMetadata(Arrays.asList(registrationMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder registrationMetadata(Consumer<RegistrationMetadataItem.Builder> ... registrationMetadata) {
            this.registrationMetadata(Stream.of(registrationMetadata).map(c -> (RegistrationMetadataItem)((RegistrationMetadataItem.Builder)RegistrationMetadataItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActivationRequest build() {
            return new CreateActivationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActivationRequest> {
        public Builder description(String var1);

        public Builder defaultInstanceName(String var1);

        public Builder iamRole(String var1);

        public Builder registrationLimit(Integer var1);

        public Builder expirationDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder registrationMetadata(Collection<RegistrationMetadataItem> var1);

        public Builder registrationMetadata(RegistrationMetadataItem ... var1);

        public Builder registrationMetadata(Consumer<RegistrationMetadataItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

