/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;

public class DescribePatchPropertiesIterable
implements SdkIterable<DescribePatchPropertiesResponse> {
    private final SsmClient client;
    private final DescribePatchPropertiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePatchPropertiesIterable(SsmClient client, DescribePatchPropertiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePatchPropertiesResponseFetcher();
    }

    public Iterator<DescribePatchPropertiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map<String, String>> properties() {
        Function<DescribePatchPropertiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.properties() != null) {
                return response.properties().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePatchPropertiesResponseFetcher
    implements SyncPageFetcher<DescribePatchPropertiesResponse> {
        private DescribePatchPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePatchPropertiesResponse nextPage(DescribePatchPropertiesResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchPropertiesIterable.this.client.describePatchProperties(DescribePatchPropertiesIterable.this.firstRequest);
            }
            return DescribePatchPropertiesIterable.this.client.describePatchProperties((DescribePatchPropertiesRequest)((Object)DescribePatchPropertiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

