/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.Session;

public class DescribeSessionsPublisher
implements SdkPublisher<DescribeSessionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSessionsPublisher(SsmAsyncClient client, DescribeSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSessionsPublisher(SsmAsyncClient client, DescribeSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Session> sessions() {
        Function<DescribeSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSessionsResponseFetcher
    implements AsyncPageFetcher<DescribeSessionsResponse> {
        private DescribeSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSessionsResponse> nextPage(DescribeSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSessionsPublisher.this.client.describeSessions(DescribeSessionsPublisher.this.firstRequest);
            }
            return DescribeSessionsPublisher.this.client.describeSessions((DescribeSessionsRequest)((Object)DescribeSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

