/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchBaselineIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchBaselineIdentity> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(PatchBaselineIdentity.getter(PatchBaselineIdentity::baselineId)).setter(PatchBaselineIdentity.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> BASELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineName").getter(PatchBaselineIdentity.getter(PatchBaselineIdentity::baselineName)).setter(PatchBaselineIdentity.setter(Builder::baselineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineName").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(PatchBaselineIdentity.getter(PatchBaselineIdentity::operatingSystemAsString)).setter(PatchBaselineIdentity.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> BASELINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineDescription").getter(PatchBaselineIdentity.getter(PatchBaselineIdentity::baselineDescription)).setter(PatchBaselineIdentity.setter(Builder::baselineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineDescription").build()}).build();
    private static final SdkField<Boolean> DEFAULT_BASELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultBaseline").getter(PatchBaselineIdentity.getter(PatchBaselineIdentity::defaultBaseline)).setter(PatchBaselineIdentity.setter(Builder::defaultBaseline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultBaseline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, BASELINE_NAME_FIELD, OPERATING_SYSTEM_FIELD, BASELINE_DESCRIPTION_FIELD, DEFAULT_BASELINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String baselineId;
    private final String baselineName;
    private final String operatingSystem;
    private final String baselineDescription;
    private final Boolean defaultBaseline;

    private PatchBaselineIdentity(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.baselineName = builder.baselineName;
        this.operatingSystem = builder.operatingSystem;
        this.baselineDescription = builder.baselineDescription;
        this.defaultBaseline = builder.defaultBaseline;
    }

    public final String baselineId() {
        return this.baselineId;
    }

    public final String baselineName() {
        return this.baselineName;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final String baselineDescription() {
        return this.baselineDescription;
    }

    public final Boolean defaultBaseline() {
        return this.defaultBaseline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBaseline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchBaselineIdentity)) {
            return false;
        }
        PatchBaselineIdentity other = (PatchBaselineIdentity)obj;
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.baselineName(), other.baselineName()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.baselineDescription(), other.baselineDescription()) && Objects.equals(this.defaultBaseline(), other.defaultBaseline());
    }

    public final String toString() {
        return ToString.builder((String)"PatchBaselineIdentity").add("BaselineId", (Object)this.baselineId()).add("BaselineName", (Object)this.baselineName()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("BaselineDescription", (Object)this.baselineDescription()).add("DefaultBaseline", (Object)this.defaultBaseline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "BaselineName": {
                return Optional.ofNullable(clazz.cast(this.baselineName()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "BaselineDescription": {
                return Optional.ofNullable(clazz.cast(this.baselineDescription()));
            }
            case "DefaultBaseline": {
                return Optional.ofNullable(clazz.cast(this.defaultBaseline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchBaselineIdentity, T> g) {
        return obj -> g.apply((PatchBaselineIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baselineId;
        private String baselineName;
        private String operatingSystem;
        private String baselineDescription;
        private Boolean defaultBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchBaselineIdentity model) {
            this.baselineId(model.baselineId);
            this.baselineName(model.baselineName);
            this.operatingSystem(model.operatingSystem);
            this.baselineDescription(model.baselineDescription);
            this.defaultBaseline(model.defaultBaseline);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        @Transient
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getBaselineName() {
            return this.baselineName;
        }

        public final void setBaselineName(String baselineName) {
            this.baselineName = baselineName;
        }

        @Override
        @Transient
        public final Builder baselineName(String baselineName) {
            this.baselineName = baselineName;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        @Transient
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getBaselineDescription() {
            return this.baselineDescription;
        }

        public final void setBaselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
        }

        @Override
        @Transient
        public final Builder baselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
            return this;
        }

        public final Boolean getDefaultBaseline() {
            return this.defaultBaseline;
        }

        public final void setDefaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
        }

        @Override
        @Transient
        public final Builder defaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
            return this;
        }

        public PatchBaselineIdentity build() {
            return new PatchBaselineIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchBaselineIdentity> {
        public Builder baselineId(String var1);

        public Builder baselineName(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder baselineDescription(String var1);

        public Builder defaultBaseline(Boolean var1);
    }
}

