/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OpsItemStatus {
    OPEN("Open"),
    IN_PROGRESS("InProgress"),
    RESOLVED("Resolved"),
    PENDING("Pending"),
    TIMED_OUT("TimedOut"),
    CANCELLING("Cancelling"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    COMPLETED_WITH_SUCCESS("CompletedWithSuccess"),
    COMPLETED_WITH_FAILURE("CompletedWithFailure"),
    SCHEDULED("Scheduled"),
    RUNBOOK_IN_PROGRESS("RunbookInProgress"),
    PENDING_CHANGE_CALENDAR_OVERRIDE("PendingChangeCalendarOverride"),
    CHANGE_CALENDAR_OVERRIDE_APPROVED("ChangeCalendarOverrideApproved"),
    CHANGE_CALENDAR_OVERRIDE_REJECTED("ChangeCalendarOverrideRejected"),
    PENDING_APPROVAL("PendingApproval"),
    APPROVED("Approved"),
    REJECTED("Rejected"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OpsItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpsItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OpsItemStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpsItemStatus> knownValues() {
        return Stream.of(OpsItemStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

