/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadataListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutomationExecutionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
    private static final SdkField<List<AutomationExecutionMetadata>> AUTOMATION_EXECUTION_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutomationExecutionMetadataList").getter(DescribeAutomationExecutionsResponse.getter(DescribeAutomationExecutionsResponse::automationExecutionMetadataList)).setter(DescribeAutomationExecutionsResponse.setter(Builder::automationExecutionMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationExecutionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAutomationExecutionsResponse.getter(DescribeAutomationExecutionsResponse::nextToken)).setter(DescribeAutomationExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutomationExecutionMetadata> automationExecutionMetadataList;
    private final String nextToken;

    private DescribeAutomationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecutionMetadataList = builder.automationExecutionMetadataList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAutomationExecutionMetadataList() {
        return this.automationExecutionMetadataList != null && !(this.automationExecutionMetadataList instanceof SdkAutoConstructList);
    }

    public List<AutomationExecutionMetadata> automationExecutionMetadataList() {
        return this.automationExecutionMetadataList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationExecutionMetadataList() ? this.automationExecutionMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationExecutionsResponse)) {
            return false;
        }
        DescribeAutomationExecutionsResponse other = (DescribeAutomationExecutionsResponse)((Object)obj);
        return this.hasAutomationExecutionMetadataList() == other.hasAutomationExecutionMetadataList() && Objects.equals(this.automationExecutionMetadataList(), other.automationExecutionMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAutomationExecutionsResponse").add("AutomationExecutionMetadataList", this.hasAutomationExecutionMetadataList() ? this.automationExecutionMetadataList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionMetadataList": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionMetadataList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutomationExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAutomationExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<AutomationExecutionMetadata> automationExecutionMetadataList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationExecutionsResponse model) {
            super(model);
            this.automationExecutionMetadataList(model.automationExecutionMetadataList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AutomationExecutionMetadata.Builder> getAutomationExecutionMetadataList() {
            if (this.automationExecutionMetadataList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.automationExecutionMetadataList != null ? (Collection)this.automationExecutionMetadataList.stream().map(AutomationExecutionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copy(automationExecutionMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(AutomationExecutionMetadata ... automationExecutionMetadataList) {
            this.automationExecutionMetadataList(Arrays.asList(automationExecutionMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationExecutionMetadataList(Consumer<AutomationExecutionMetadata.Builder> ... automationExecutionMetadataList) {
            this.automationExecutionMetadataList(Stream.of(automationExecutionMetadataList).map(c -> (AutomationExecutionMetadata)((AutomationExecutionMetadata.Builder)AutomationExecutionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutomationExecutionMetadataList(Collection<AutomationExecutionMetadata.BuilderImpl> automationExecutionMetadataList) {
            this.automationExecutionMetadataList = AutomationExecutionMetadataListCopier.copyFromBuilder(automationExecutionMetadataList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationExecutionsResponse build() {
            return new DescribeAutomationExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutomationExecutionsResponse> {
        public Builder automationExecutionMetadataList(Collection<AutomationExecutionMetadata> var1);

        public Builder automationExecutionMetadataList(AutomationExecutionMetadata ... var1);

        public Builder automationExecutionMetadataList(Consumer<AutomationExecutionMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

