/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterTier;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutParameterRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, PutParameterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutParameterRequest.getter(PutParameterRequest::name)).setter(PutParameterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutParameterRequest.getter(PutParameterRequest::description)).setter(PutParameterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(PutParameterRequest.getter(PutParameterRequest::value)).setter(PutParameterRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PutParameterRequest.getter(PutParameterRequest::typeAsString)).setter(PutParameterRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(PutParameterRequest.getter(PutParameterRequest::keyId)).setter(PutParameterRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Overwrite").getter(PutParameterRequest.getter(PutParameterRequest::overwrite)).setter(PutParameterRequest.setter(Builder::overwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()}).build();
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedPattern").getter(PutParameterRequest.getter(PutParameterRequest::allowedPattern)).setter(PutParameterRequest.setter(Builder::allowedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPattern").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutParameterRequest.getter(PutParameterRequest::tags)).setter(PutParameterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(PutParameterRequest.getter(PutParameterRequest::tierAsString)).setter(PutParameterRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policies").getter(PutParameterRequest.getter(PutParameterRequest::policies)).setter(PutParameterRequest.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(PutParameterRequest.getter(PutParameterRequest::dataType)).setter(PutParameterRequest.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, VALUE_FIELD, TYPE_FIELD, KEY_ID_FIELD, OVERWRITE_FIELD, ALLOWED_PATTERN_FIELD, TAGS_FIELD, TIER_FIELD, POLICIES_FIELD, DATA_TYPE_FIELD));
    private final String name;
    private final String description;
    private final String value;
    private final String type;
    private final String keyId;
    private final Boolean overwrite;
    private final String allowedPattern;
    private final List<Tag> tags;
    private final String tier;
    private final String policies;
    private final String dataType;

    private PutParameterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.value = builder.value;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.overwrite = builder.overwrite;
        this.allowedPattern = builder.allowedPattern;
        this.tags = builder.tags;
        this.tier = builder.tier;
        this.policies = builder.policies;
        this.dataType = builder.dataType;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String value() {
        return this.value;
    }

    public ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public Boolean overwrite() {
        return this.overwrite;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public ParameterTier tier() {
        return ParameterTier.fromValue(this.tier);
    }

    public String tierAsString() {
        return this.tier;
    }

    public String policies() {
        return this.policies;
    }

    public String dataType() {
        return this.dataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutParameterRequest)) {
            return false;
        }
        PutParameterRequest other = (PutParameterRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.overwrite(), other.overwrite()) && Objects.equals(this.allowedPattern(), other.allowedPattern()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.dataType(), other.dataType());
    }

    public String toString() {
        return ToString.builder((String)"PutParameterRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Value", (Object)this.value()).add("Type", (Object)this.typeAsString()).add("KeyId", (Object)this.keyId()).add("Overwrite", (Object)this.overwrite()).add("AllowedPattern", (Object)this.allowedPattern()).add("Tags", this.hasTags() ? this.tags() : null).add("Tier", (Object)this.tierAsString()).add("Policies", (Object)this.policies()).add("DataType", (Object)this.dataType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Overwrite": {
                return Optional.ofNullable(clazz.cast(this.overwrite()));
            }
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutParameterRequest, T> g) {
        return obj -> g.apply((PutParameterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String value;
        private String type;
        private String keyId;
        private Boolean overwrite;
        private String allowedPattern;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String tier;
        private String policies;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutParameterRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.value(model.value);
            this.type(model.type);
            this.keyId(model.keyId);
            this.overwrite(model.overwrite);
            this.allowedPattern(model.allowedPattern);
            this.tags(model.tags);
            this.tier(model.tier);
            this.policies(model.policies);
            this.dataType(model.dataType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Boolean getOverwrite() {
            return this.overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ParameterTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final String getPolicies() {
            return this.policies;
        }

        @Override
        public final Builder policies(String policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(String policies) {
            this.policies = policies;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutParameterRequest build() {
            return new PutParameterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutParameterRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder overwrite(Boolean var1);

        public Builder allowedPattern(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder tier(String var1);

        public Builder tier(ParameterTier var1);

        public Builder policies(String var1);

        public Builder dataType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

