/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentityListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchBaselinesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchBaselinesResponse> {
    private static final SdkField<List<PatchBaselineIdentity>> BASELINE_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaselineIdentities").getter(DescribePatchBaselinesResponse.getter(DescribePatchBaselinesResponse::baselineIdentities)).setter(DescribePatchBaselinesResponse.setter(Builder::baselineIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchBaselineIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePatchBaselinesResponse.getter(DescribePatchBaselinesResponse::nextToken)).setter(DescribePatchBaselinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PatchBaselineIdentity> baselineIdentities;
    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        super(builder);
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBaselineIdentities() {
        return this.baselineIdentities != null && !(this.baselineIdentities instanceof SdkAutoConstructList);
    }

    public List<PatchBaselineIdentity> baselineIdentities() {
        return this.baselineIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaselineIdentities() ? this.baselineIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse)((Object)obj);
        return this.hasBaselineIdentities() == other.hasBaselineIdentities() && Objects.equals(this.baselineIdentities(), other.baselineIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchBaselinesResponse").add("BaselineIdentities", this.hasBaselineIdentities() ? this.baselineIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineIdentities": {
                return Optional.ofNullable(clazz.cast(this.baselineIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchBaselinesResponse, T> g) {
        return obj -> g.apply((DescribePatchBaselinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            super(model);
            this.baselineIdentities(model.baselineIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity.Builder> getBaselineIdentities() {
            if (this.baselineIdentities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.baselineIdentities != null ? (Collection)this.baselineIdentities.stream().map(PatchBaselineIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity ... baselineIdentities) {
            this.baselineIdentities(Arrays.asList(baselineIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder> ... baselineIdentities) {
            this.baselineIdentities(Stream.of(baselineIdentities).map(c -> (PatchBaselineIdentity)((PatchBaselineIdentity.Builder)PatchBaselineIdentity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity.BuilderImpl> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copyFromBuilder(baselineIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        public Builder baselineIdentities(Collection<PatchBaselineIdentity> var1);

        public Builder baselineIdentities(PatchBaselineIdentity ... var1);

        public Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

