/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;

public class DescribeAssociationExecutionTargetsIterable
implements SdkIterable<DescribeAssociationExecutionTargetsResponse> {
    private final SsmClient client;
    private final DescribeAssociationExecutionTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAssociationExecutionTargetsIterable(SsmClient client, DescribeAssociationExecutionTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAssociationExecutionTargetsResponseFetcher();
    }

    public Iterator<DescribeAssociationExecutionTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociationExecutionTarget> associationExecutionTargets() {
        Function<DescribeAssociationExecutionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associationExecutionTargets() != null) {
                return response.associationExecutionTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAssociationExecutionTargetsResponseFetcher
    implements SyncPageFetcher<DescribeAssociationExecutionTargetsResponse> {
        private DescribeAssociationExecutionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAssociationExecutionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAssociationExecutionTargetsResponse nextPage(DescribeAssociationExecutionTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAssociationExecutionTargetsIterable.this.client.describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsIterable.this.firstRequest);
            }
            return DescribeAssociationExecutionTargetsIterable.this.client.describeAssociationExecutionTargets((DescribeAssociationExecutionTargetsRequest)((Object)DescribeAssociationExecutionTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

