/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComplianceItemsRequest extends SsmRequest implements
        ToCopyableBuilder<ListComplianceItemsRequest.Builder, ListComplianceItemsRequest> {
    private static final SdkField<List<ComplianceStringFilter>> FILTERS_FIELD = SdkField
            .<List<ComplianceStringFilter>> builder(MarshallingType.LIST)
            .getter(getter(ListComplianceItemsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListComplianceItemsRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListComplianceItemsRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListComplianceItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListComplianceItemsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            RESOURCE_IDS_FIELD, RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<ComplianceStringFilter> filters;

    private final List<String> resourceIds;

    private final List<String> resourceTypes;

    private final String nextToken;

    private final Integer maxResults;

    private ListComplianceItemsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.resourceIds = builder.resourceIds;
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more compliance filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more compliance filters. Use a filter to return a more specific list of results.
     */
    public List<ComplianceStringFilter> filters() {
        return filters;
    }

    /**
     * Returns true if the ResourceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID for the resources from which to get compliance information. Currently, you can only specify one resource
     * ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID for the resources from which to get compliance information. Currently, you can only specify one
     *         resource ID.
     */
    public List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * Returns true if the ResourceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of resource from which to get compliance information. Currently, the only supported resource type is
     * <code>ManagedInstance</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type of resource from which to get compliance information. Currently, the only supported resource
     *         type is <code>ManagedInstance</code>.
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsRequest)) {
            return false;
        }
        ListComplianceItemsRequest other = (ListComplianceItemsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListComplianceItemsRequest").add("Filters", filters()).add("ResourceIds", resourceIds())
                .add("ResourceTypes", resourceTypes()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceItemsRequest, T> g) {
        return obj -> g.apply((ListComplianceItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListComplianceItemsRequest> {
        /**
         * <p>
         * One or more compliance filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more compliance filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ComplianceStringFilter> filters);

        /**
         * <p>
         * One or more compliance filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more compliance filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ComplianceStringFilter... filters);

        /**
         * <p>
         * One or more compliance filters. Use a filter to return a more specific list of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceStringFilter>.Builder} avoiding
         * the need to create one manually via {@link List<ComplianceStringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceStringFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ComplianceStringFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ComplianceStringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ComplianceStringFilter>)
         */
        Builder filters(Consumer<ComplianceStringFilter.Builder>... filters);

        /**
         * <p>
         * The ID for the resources from which to get compliance information. Currently, you can only specify one
         * resource ID.
         * </p>
         * 
         * @param resourceIds
         *        The ID for the resources from which to get compliance information. Currently, you can only specify one
         *        resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * The ID for the resources from which to get compliance information. Currently, you can only specify one
         * resource ID.
         * </p>
         * 
         * @param resourceIds
         *        The ID for the resources from which to get compliance information. Currently, you can only specify one
         *        resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The type of resource from which to get compliance information. Currently, the only supported resource type is
         * <code>ManagedInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The type of resource from which to get compliance information. Currently, the only supported resource
         *        type is <code>ManagedInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The type of resource from which to get compliance information. Currently, the only supported resource type is
         * <code>ManagedInstance</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The type of resource from which to get compliance information. Currently, the only supported resource
         *        type is <code>ManagedInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<ComplianceStringFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsRequest model) {
            super(model);
            filters(model.filters);
            resourceIds(model.resourceIds);
            resourceTypes(model.resourceTypes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<ComplianceStringFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ComplianceStringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ComplianceStringFilter> filters) {
            this.filters = ComplianceStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ComplianceStringFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ComplianceStringFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ComplianceStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ComplianceStringFilter.BuilderImpl> filters) {
            this.filters = ComplianceStringFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getResourceIds() {
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ComplianceResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ComplianceResourceIdListCopier.copy(resourceIds);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ComplianceResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ComplianceResourceTypeListCopier.copy(resourceTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComplianceItemsRequest build() {
            return new ListComplianceItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
