/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationConfigMarshaller {
    private static final MarshallingInfo<String> NOTIFICATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationArn").isBinary(false).build();
    private static final MarshallingInfo<List> NOTIFICATIONEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationEvents").isBinary(false).build();
    private static final MarshallingInfo<String> NOTIFICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationType").isBinary(false).build();
    private static final NotificationConfigMarshaller INSTANCE = new NotificationConfigMarshaller();

    private NotificationConfigMarshaller() {
    }

    public static NotificationConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationConfig notificationConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notificationConfig, (String)"notificationConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notificationConfig.notificationArn(), NOTIFICATIONARN_BINDING);
            protocolMarshaller.marshall(notificationConfig.notificationEventsStrings(), NOTIFICATIONEVENTS_BINDING);
            protocolMarshaller.marshall((Object)notificationConfig.notificationTypeString(), NOTIFICATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

