/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstancePatchStateMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> PATCHGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchGroup").isBinary(false).build();
    private static final MarshallingInfo<String> BASELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineId").isBinary(false).build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTALLEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTALLEDOTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledOtherCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> MISSINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> NOTAPPLICABLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotApplicableCount").isBinary(false).build();
    private static final MarshallingInfo<Instant> OPERATIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> OPERATIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationEndTime").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").isBinary(false).build();
    private static final InstancePatchStateMarshaller INSTANCE = new InstancePatchStateMarshaller();

    private InstancePatchStateMarshaller() {
    }

    public static InstancePatchStateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstancePatchState instancePatchState, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instancePatchState, (String)"instancePatchState");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instancePatchState.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.patchGroup(), PATCHGROUP_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.baselineId(), BASELINEID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.snapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.installedCount(), INSTALLEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.installedOtherCount(), INSTALLEDOTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.missingCount(), MISSINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.failedCount(), FAILEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.notApplicableCount(), NOTAPPLICABLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operationStartTime(), OPERATIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operationEndTime(), OPERATIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)instancePatchState.operationString(), OPERATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

