/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetInventorySchemaRequestModelMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AGGREGATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aggregator").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SUBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubType").isBinary(false).build();
    private static final GetInventorySchemaRequestModelMarshaller INSTANCE = new GetInventorySchemaRequestModelMarshaller();

    private GetInventorySchemaRequestModelMarshaller() {
    }

    public static GetInventorySchemaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetInventorySchemaRequest getInventorySchemaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getInventorySchemaRequest), (String)"getInventorySchemaRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getInventorySchemaRequest.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)getInventorySchemaRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getInventorySchemaRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)getInventorySchemaRequest.aggregator(), AGGREGATOR_BINDING);
            protocolMarshaller.marshall((Object)getInventorySchemaRequest.subType(), SUBTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

