/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.DocumentParameter;
import software.amazon.awssdk.services.ssm.model.DocumentParameterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentStatus;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.services.ssm.transform.DocumentDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentDescription> {
    private final String sha1;
    private final String hash;
    private final String hashType;
    private final String name;
    private final String owner;
    private final Instant createdDate;
    private final String status;
    private final String documentVersion;
    private final String description;
    private final List<DocumentParameter> parameters;
    private final List<String> platformTypes;
    private final String documentType;
    private final String schemaVersion;
    private final String latestVersion;
    private final String defaultVersion;
    private final List<Tag> tags;

    private DocumentDescription(BuilderImpl builder) {
        this.sha1 = builder.sha1;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.name = builder.name;
        this.owner = builder.owner;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.documentVersion = builder.documentVersion;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.platformTypes = builder.platformTypes;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.latestVersion = builder.latestVersion;
        this.defaultVersion = builder.defaultVersion;
        this.tags = builder.tags;
    }

    public String sha1() {
        return this.sha1;
    }

    public String hash() {
        return this.hash;
    }

    public DocumentHashType hashType() {
        return DocumentHashType.fromValue(this.hashType);
    }

    public String hashTypeString() {
        return this.hashType;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public DocumentStatus status() {
        return DocumentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String description() {
        return this.description;
    }

    public List<DocumentParameter> parameters() {
        return this.parameters;
    }

    public List<PlatformType> platformTypes() {
        return TypeConverter.convert(this.platformTypes, PlatformType::fromValue);
    }

    public List<String> platformTypesStrings() {
        return this.platformTypes;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeString() {
        return this.documentType;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sha1());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        return Objects.equals(this.sha1(), other.sha1()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.hashTypeString(), other.hashTypeString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.platformTypesStrings(), other.platformTypesStrings()) && Objects.equals(this.documentTypeString(), other.documentTypeString()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DocumentDescription").add("Sha1", (Object)this.sha1()).add("Hash", (Object)this.hash()).add("HashType", (Object)this.hashTypeString()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("CreatedDate", (Object)this.createdDate()).add("Status", (Object)this.statusString()).add("DocumentVersion", (Object)this.documentVersion()).add("Description", (Object)this.description()).add("Parameters", this.parameters()).add("PlatformTypes", this.platformTypesStrings()).add("DocumentType", (Object)this.documentTypeString()).add("SchemaVersion", (Object)this.schemaVersion()).add("LatestVersion", (Object)this.latestVersion()).add("DefaultVersion", (Object)this.defaultVersion()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sha1": {
                return Optional.of(clazz.cast(this.sha1()));
            }
            case "Hash": {
                return Optional.of(clazz.cast(this.hash()));
            }
            case "HashType": {
                return Optional.of(clazz.cast(this.hashTypeString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "PlatformTypes": {
                return Optional.of(clazz.cast(this.platformTypesStrings()));
            }
            case "DocumentType": {
                return Optional.of(clazz.cast(this.documentTypeString()));
            }
            case "SchemaVersion": {
                return Optional.of(clazz.cast(this.schemaVersion()));
            }
            case "LatestVersion": {
                return Optional.of(clazz.cast(this.latestVersion()));
            }
            case "DefaultVersion": {
                return Optional.of(clazz.cast(this.defaultVersion()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sha1;
        private String hash;
        private String hashType;
        private String name;
        private String owner;
        private Instant createdDate;
        private String status;
        private String documentVersion;
        private String description;
        private List<DocumentParameter> parameters;
        private List<String> platformTypes;
        private String documentType;
        private String schemaVersion;
        private String latestVersion;
        private String defaultVersion;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDescription model) {
            this.sha1(model.sha1);
            this.hash(model.hash);
            this.hashType(model.hashType);
            this.name(model.name);
            this.owner(model.owner);
            this.createdDate(model.createdDate);
            this.status(model.status);
            this.documentVersion(model.documentVersion);
            this.description(model.description);
            this.parameters(model.parameters);
            this.platformTypes(model.platformTypes);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
            this.latestVersion(model.latestVersion);
            this.defaultVersion(model.defaultVersion);
            this.tags(model.tags);
        }

        public final String getSha1() {
            return this.sha1;
        }

        @Override
        public final Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public final void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public final String getHash() {
            return this.hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashType() {
            return this.hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(DocumentHashType hashType) {
            this.hashType(hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentParameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(DocumentParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(DocumentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<DocumentParameter.BuilderImpl> parameters) {
            this.parameters = DocumentParameterListCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getPlatformTypes() {
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public DocumentDescription build() {
            return new DocumentDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentDescription> {
        public Builder sha1(String var1);

        public Builder hash(String var1);

        public Builder hashType(String var1);

        public Builder hashType(DocumentHashType var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder createdDate(Instant var1);

        public Builder status(String var1);

        public Builder status(DocumentStatus var1);

        public Builder documentVersion(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<DocumentParameter> var1);

        public Builder parameters(DocumentParameter ... var1);

        public Builder platformTypes(Collection<String> var1);

        public Builder platformTypes(String ... var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder latestVersion(String var1);

        public Builder defaultVersion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

