/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteParametersResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DeleteParametersResponse> {
    private final List<String> deletedParameters;
    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        super(builder);
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    public List<String> deletedParameters() {
        return this.deletedParameters;
    }

    public List<String> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse)((Object)obj);
        return Objects.equals(this.deletedParameters(), other.deletedParameters()) && Objects.equals(this.invalidParameters(), other.invalidParameters());
    }

    public String toString() {
        return ToString.builder((String)"DeleteParametersResponse").add("DeletedParameters", this.deletedParameters()).add("InvalidParameters", this.invalidParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletedParameters": {
                return Optional.of(clazz.cast(this.deletedParameters()));
            }
            case "InvalidParameters": {
                return Optional.of(clazz.cast(this.invalidParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<String> deletedParameters;
        private List<String> invalidParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            this.deletedParameters(model.deletedParameters);
            this.invalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            return this.deletedParameters;
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String ... deletedParameters) {
            this.deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        public final Collection<String> getInvalidParameters() {
            return this.invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String ... invalidParameters) {
            this.invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DeleteParametersResponse> {
        public Builder deletedParameters(Collection<String> var1);

        public Builder deletedParameters(String ... var1);

        public Builder invalidParameters(Collection<String> var1);

        public Builder invalidParameters(String ... var1);
    }
}

