/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;

@SdkInternalApi
public class PatchBaselineIdentityMarshaller {
    private static final MarshallingInfo<String> BASELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineId").build();
    private static final MarshallingInfo<String> BASELINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineName").build();
    private static final MarshallingInfo<String> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").build();
    private static final MarshallingInfo<String> BASELINEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineDescription").build();
    private static final MarshallingInfo<Boolean> DEFAULTBASELINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultBaseline").build();
    private static final PatchBaselineIdentityMarshaller INSTANCE = new PatchBaselineIdentityMarshaller();

    public static PatchBaselineIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchBaselineIdentity patchBaselineIdentity, ProtocolMarshaller protocolMarshaller) {
        if (patchBaselineIdentity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)patchBaselineIdentity.baselineId(), BASELINEID_BINDING);
            protocolMarshaller.marshall((Object)patchBaselineIdentity.baselineName(), BASELINENAME_BINDING);
            protocolMarshaller.marshall((Object)patchBaselineIdentity.operatingSystemString(), OPERATINGSYSTEM_BINDING);
            protocolMarshaller.marshall((Object)patchBaselineIdentity.baselineDescription(), BASELINEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)patchBaselineIdentity.defaultBaseline(), DEFAULTBASELINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

