/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;

@SdkInternalApi
public class AddTagsToResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final AddTagsToResourceRequestModelMarshaller INSTANCE = new AddTagsToResourceRequestModelMarshaller();

    public static AddTagsToResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddTagsToResourceRequest addTagsToResourceRequest, ProtocolMarshaller protocolMarshaller) {
        if (addTagsToResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)addTagsToResourceRequest.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)addTagsToResourceRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(addTagsToResourceRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

