/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

public final class DescribeInstanceInformationPaginator
implements SdkIterable<DescribeInstanceInformationResponse> {
    private final SSMClient client;
    private final DescribeInstanceInformationRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeInstanceInformationPaginator(SSMClient client, DescribeInstanceInformationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceInformationResponseFetcher();
    }

    public Iterator<DescribeInstanceInformationResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceInformation> instanceInformationList() {
        Function<DescribeInstanceInformationResponse, Iterator> getIterator = response -> response != null ? response.instanceInformationList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeInstanceInformationResponseFetcher
    implements NextPageFetcher<DescribeInstanceInformationResponse> {
        private DescribeInstanceInformationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceInformationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeInstanceInformationResponse nextPage(DescribeInstanceInformationResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceInformationPaginator.this.client.describeInstanceInformation(DescribeInstanceInformationPaginator.this.firstRequest);
            }
            return DescribeInstanceInformationPaginator.this.client.describeInstanceInformation((DescribeInstanceInformationRequest)((Object)DescribeInstanceInformationPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

