/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdatePatchBaselineRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, UpdatePatchBaselineRequest> {
    private final String baselineId;
    private final String name;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final String approvedPatchesComplianceLevel;
    private final List<String> rejectedPatches;
    private final String description;

    private UpdatePatchBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.rejectedPatches = builder.rejectedPatches;
        this.description = builder.description;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String name() {
        return this.name;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(this.approvedPatchesComplianceLevel);
    }

    public String approvedPatchesComplianceLevelString() {
        return this.approvedPatchesComplianceLevel;
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesComplianceLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineRequest)) {
            return false;
        }
        UpdatePatchBaselineRequest other = (UpdatePatchBaselineRequest)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.globalFilters(), other.globalFilters()) && Objects.equals(this.approvalRules(), other.approvalRules()) && Objects.equals(this.approvedPatches(), other.approvedPatches()) && Objects.equals(this.approvedPatchesComplianceLevelString(), other.approvedPatchesComplianceLevelString()) && Objects.equals(this.rejectedPatches(), other.rejectedPatches()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePatchBaselineRequest").add("BaselineId", (Object)this.baselineId()).add("Name", (Object)this.name()).add("GlobalFilters", (Object)this.globalFilters()).add("ApprovalRules", (Object)this.approvalRules()).add("ApprovedPatches", this.approvedPatches()).add("ApprovedPatchesComplianceLevel", (Object)this.approvedPatchesComplianceLevelString()).add("RejectedPatches", this.rejectedPatches()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.of(clazz.cast(this.baselineId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "GlobalFilters": {
                return Optional.of(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.of(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.of(clazz.cast(this.approvedPatches()));
            }
            case "ApprovedPatchesComplianceLevel": {
                return Optional.of(clazz.cast(this.approvedPatchesComplianceLevelString()));
            }
            case "RejectedPatches": {
                return Optional.of(clazz.cast(this.rejectedPatches()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches;
        private String approvedPatchesComplianceLevel;
        private List<String> rejectedPatches;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePatchBaselineRequest model) {
            this.baselineId(model.baselineId);
            this.name(model.name);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            this.rejectedPatches(model.rejectedPatches);
            this.description(model.description);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return this.approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Collection<String> getRejectedPatches() {
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdatePatchBaselineRequest build() {
            return new UpdatePatchBaselineRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, UpdatePatchBaselineRequest> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder globalFilters(PatchFilterGroup var1);

        default public Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return this.globalFilters((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().apply(globalFilters)).build());
        }

        public Builder approvalRules(PatchRuleGroup var1);

        default public Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return this.approvalRules((PatchRuleGroup)((PatchRuleGroup.Builder)PatchRuleGroup.builder().apply(approvalRules)).build());
        }

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder approvedPatchesComplianceLevel(String var1);

        public Builder approvedPatchesComplianceLevel(PatchComplianceLevel var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

