/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterTaskWithMaintenanceWindowRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
    private final String windowId;
    private final List<Target> targets;
    private final String taskArn;
    private final String serviceRoleArn;
    private final String taskType;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final LoggingInfo loggingInfo;
    private final String name;
    private final String description;
    private final String clientToken;

    private RegisterTaskWithMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskType = builder.taskType;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String windowId() {
        return this.windowId;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public String taskTypeString() {
        return this.taskType;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return this.taskInvocationParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowRequest other = (RegisterTaskWithMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.taskTypeString(), other.taskTypeString()) && Objects.equals(this.taskParameters(), other.taskParameters()) && Objects.equals(this.taskInvocationParameters(), other.taskInvocationParameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"RegisterTaskWithMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("Targets", this.targets()).add("TaskArn", (Object)this.taskArn()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TaskType", (Object)this.taskTypeString()).add("TaskParameters", this.taskParameters()).add("TaskInvocationParameters", (Object)this.taskInvocationParameters()).add("Priority", (Object)this.priority()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("LoggingInfo", (Object)this.loggingInfo()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "TaskArn": {
                return Optional.of(clazz.cast(this.taskArn()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "TaskType": {
                return Optional.of(clazz.cast(this.taskTypeString()));
            }
            case "TaskParameters": {
                return Optional.of(clazz.cast(this.taskParameters()));
            }
            case "TaskInvocationParameters": {
                return Optional.of(clazz.cast(this.taskInvocationParameters()));
            }
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "MaxConcurrency": {
                return Optional.of(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.of(clazz.cast(this.maxErrors()));
            }
            case "LoggingInfo": {
                return Optional.of(clazz.cast(this.loggingInfo()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private List<Target> targets;
        private String taskArn;
        private String serviceRoleArn;
        private String taskType;
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private LoggingInfo loggingInfo;
        private String name;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskWithMaintenanceWindowRequest model) {
            this.windowId(model.windowId);
            this.targets(model.targets);
            this.taskArn(model.taskArn);
            this.serviceRoleArn(model.serviceRoleArn);
            this.taskType(model.taskType);
            this.taskParameters(model.taskParameters);
            this.taskInvocationParameters(model.taskInvocationParameters);
            this.priority(model.priority);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.loggingInfo(model.loggingInfo);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            return this.taskParameters != null ? CollectionUtils.mapValues(this.taskParameters, MaintenanceWindowTaskParameterValueExpression::toBuilder) : null;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return this.taskInvocationParameters != null ? this.taskInvocationParameters.toBuilder() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final void setTaskInvocationParameters(MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterTaskWithMaintenanceWindowRequest build() {
            return new RegisterTaskWithMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder taskArn(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters var1);

        default public Builder taskInvocationParameters(Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return this.taskInvocationParameters((MaintenanceWindowTaskInvocationParameters)((MaintenanceWindowTaskInvocationParameters.Builder)MaintenanceWindowTaskInvocationParameters.builder().apply(taskInvocationParameters)).build());
        }

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().apply(loggingInfo)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

