/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.services.ssm.model.ComplianceItemListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListComplianceItemsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, ListComplianceItemsResponse> {
    private final List<ComplianceItem> complianceItems;
    private final String nextToken;

    private ListComplianceItemsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceItems = builder.complianceItems;
        this.nextToken = builder.nextToken;
    }

    public List<ComplianceItem> complianceItems() {
        return this.complianceItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsResponse)) {
            return false;
        }
        ListComplianceItemsResponse other = (ListComplianceItemsResponse)((Object)obj);
        return Objects.equals(this.complianceItems(), other.complianceItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListComplianceItemsResponse").add("ComplianceItems", this.complianceItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceItems": {
                return Optional.of(clazz.cast(this.complianceItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<ComplianceItem> complianceItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsResponse model) {
            this.complianceItems(model.complianceItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ComplianceItem.Builder> getComplianceItems() {
            return this.complianceItems != null ? (Collection)this.complianceItems.stream().map(ComplianceItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceItems(Collection<ComplianceItem> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copy(complianceItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(ComplianceItem ... complianceItems) {
            this.complianceItems(Arrays.asList(complianceItems));
            return this;
        }

        public final void setComplianceItems(Collection<ComplianceItem.BuilderImpl> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copyFromBuilder(complianceItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceItemsResponse build() {
            return new ListComplianceItemsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, ListComplianceItemsResponse> {
        public Builder complianceItems(Collection<ComplianceItem> var1);

        public Builder complianceItems(ComplianceItem ... var1);

        public Builder nextToken(String var1);
    }
}

