/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersListCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionTaskResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskResponse> {
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String taskArn;
    private final String serviceRole;
    private final String type;
    private final List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;

    private GetMaintenanceWindowExecutionTaskResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.taskArn = builder.taskArn;
        this.serviceRole = builder.serviceRole;
        this.type = builder.type;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public MaintenanceWindowTaskType type() {
        return MaintenanceWindowTaskType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters() {
        return this.taskParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskResponse other = (GetMaintenanceWindowExecutionTaskResponse)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskExecutionId(), other.taskExecutionId()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.taskParameters(), other.taskParameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"GetMaintenanceWindowExecutionTaskResponse").add("WindowExecutionId", (Object)this.windowExecutionId()).add("TaskExecutionId", (Object)this.taskExecutionId()).add("TaskArn", (Object)this.taskArn()).add("ServiceRole", (Object)this.serviceRole()).add("Type", (Object)this.typeString()).add("TaskParameters", this.taskParameters()).add("Priority", (Object)this.priority()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Status", (Object)this.statusString()).add("StatusDetails", (Object)this.statusDetails()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskExecutionId": {
                return Optional.of(clazz.cast(this.taskExecutionId()));
            }
            case "TaskArn": {
                return Optional.of(clazz.cast(this.taskArn()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "TaskParameters": {
                return Optional.of(clazz.cast(this.taskParameters()));
            }
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "MaxConcurrency": {
                return Optional.of(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.of(clazz.cast(this.maxErrors()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String taskArn;
        private String serviceRole;
        private String type;
        private List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskResponse model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskExecutionId(model.taskExecutionId);
            this.taskArn(model.taskArn);
            this.serviceRole(model.serviceRole);
            this.type(model.type);
            this.taskParameters(model.taskParameters);
            this.priority(model.priority);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowTaskType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> getTaskParameters() {
            return this.taskParameters;
        }

        @Override
        public final Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> ... taskParameters) {
            this.taskParameters(Arrays.asList(taskParameters));
            return this;
        }

        public final void setTaskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskResponse build() {
            return new GetMaintenanceWindowExecutionTaskResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskResponse> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder taskArn(String var1);

        public Builder serviceRole(String var1);

        public Builder type(String var1);

        public Builder type(MaintenanceWindowTaskType var1);

        public Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> ... var1);

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

